/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.Arrays;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;

public class CircularString
extends LineString
implements SingleCurvedGeometry<LineString> {
    private static final long serialVersionUID = -5796254063449438787L;
    static final CoordinateSequence FAKE_STRING_2D = new CoordinateArraySequence(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)});
    double[] controlPoints;
    double tolerance;
    LineString linearized;

    public CircularString(CoordinateSequence points, GeometryFactory factory, double tolerance) {
        super(FAKE_STRING_2D, factory);
        this.tolerance = tolerance;
        if (points.getDimension() != 2) {
            throw new IllegalArgumentException("Circular strings are restricted to 2 dimensions at the moment. Contributions to get ND support welcomed!");
        }
        int pointCount = points.size();
        this.controlPoints = new double[pointCount * 2];
        for (int i = 0; i < pointCount; ++i) {
            this.controlPoints[i * 2] = points.getX(i);
            this.controlPoints[i * 2 + 1] = points.getY(i);
        }
        this.init(this.controlPoints, tolerance);
    }

    public CircularString(double[] controlPoints, GeometryFactory factory, double tolerance) {
        super(FAKE_STRING_2D, factory);
        this.init(controlPoints, tolerance);
    }

    private void init(double[] controlPoints, double tolerance) {
        int length = controlPoints.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of ordinates, must be even, but it is " + length + " instead");
        }
        int pointCount = length / 2;
        if (pointCount < 3 || pointCount > 3 && pointCount % 2 == 0) {
            throw new IllegalArgumentException("Invalid number of points, a circular stringis always made of an odd number of points, with a mininum of 3, and adding 2 for each extra circular arc in the sequence");
        }
        this.controlPoints = controlPoints;
        this.tolerance = tolerance;
    }

    @Override
    public double[] getControlPoints() {
        return this.controlPoints;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getNumArcs() {
        return (this.controlPoints.length - 6) / 4 + 1;
    }

    @Override
    public CircularArc getArcN(int arcIndex) {
        int baseIdx = arcIndex * 4;
        double[] arcControlPoints = new double[6];
        System.arraycopy(this.controlPoints, baseIdx, arcControlPoints, 0, 6);
        CircularArc arc = new CircularArc(arcControlPoints);
        return arc;
    }

    @Override
    public LineString linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public LineString linearize(double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized;
        }
        CoordinateSequence cs = this.getLinearizedCoordinateSequence(tolerance);
        LineString result = new LineString(cs, this.factory);
        if (isDefaultTolerance) {
            this.linearized = result;
        }
        return result;
    }

    @Override
    public CoordinateSequence getLinearizedCoordinateSequence(final double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized.getCoordinateSequence();
        }
        final GrowableOrdinateArray gar = new GrowableOrdinateArray();
        new ArcScan(){

            @Override
            protected void visitArc(CircularArc arc) {
                if (gar.size() > 0) {
                    gar.setSize(gar.size() - 2);
                }
                arc.linearize(tolerance, gar);
            }
        };
        CoordinateSequence cs = gar.toCoordinateSequence(this.getFactory());
        return cs;
    }

    public boolean isClosed() {
        return this.controlPoints[0] == this.controlPoints[this.controlPoints.length - 2] && this.controlPoints[1] == this.controlPoints[this.controlPoints.length - 1];
    }

    public int getDimension() {
        return super.getDimension();
    }

    public int getBoundaryDimension() {
        return super.getDimension();
    }

    public boolean isEmpty() {
        return false;
    }

    public String getGeometryType() {
        return "CircularString";
    }

    public Geometry reverse() {
        double[] reversed = new double[this.controlPoints.length];
        System.arraycopy(this.controlPoints, 0, reversed, 0, this.controlPoints.length);
        GrowableOrdinateArray array = new GrowableOrdinateArray();
        array.addAll(this.controlPoints);
        array.reverseOrdinates(0, array.size() - 1);
        return new CircularString(array.getData(), this.getFactory(), this.tolerance);
    }

    public Point getInteriorPoint() {
        int idx = this.controlPoints.length / 2;
        return new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[idx], this.controlPoints[idx + 1])}), this.getFactory());
    }

    public Geometry getEnvelope() {
        return super.getEnvelope();
    }

    public Envelope getEnvelopeInternal() {
        return super.getEnvelopeInternal();
    }

    protected Envelope computeEnvelopeInternal() {
        final Envelope result = new Envelope();
        new ArcScan(){

            @Override
            protected void visitArc(CircularArc arc) {
                arc.expandEnvelope(result);
            }
        };
        return result;
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    public int getSRID() {
        return super.getSRID();
    }

    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    public Object getUserData() {
        return super.getUserData();
    }

    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    public boolean isRectangle() {
        return false;
    }

    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    public boolean equals(Geometry other) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equals(other);
    }

    public boolean equalsTopo(Geometry other) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equalsTopo(other);
    }

    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            return this.equals((Geometry)o);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("CIRCULARSTRING(");
        int i = 0;
        while (i < this.controlPoints.length) {
            sb.append(this.controlPoints[i++] + " " + this.controlPoints[i++]);
            if (i >= this.controlPoints.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    public Point getPointN(int n) {
        if (n == 0) {
            return this.getStartPoint();
        }
        return this.linearize().getPointN(n);
    }

    public Point getStartPoint() {
        return new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[0], this.controlPoints[1])}), this.getFactory());
    }

    public Point getEndPoint() {
        return new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[this.controlPoints.length - 2], this.controlPoints[this.controlPoints.length - 1])}), this.getFactory());
    }

    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.linearize().getCoordinateSequence();
    }

    public Coordinate getCoordinateN(int n) {
        return this.linearize().getCoordinateN(n);
    }

    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    public int getNumPoints() {
        return this.linearize().getNumPoints();
    }

    public boolean isRing() {
        return this.linearize().isRing();
    }

    public double getLength() {
        return this.linearize().getLength();
    }

    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    public void normalize() {
        this.linearize().normalize();
    }

    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    public boolean isValid() {
        return this.linearize().isValid();
    }

    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    public double getArea() {
        return this.linearize().getArea();
    }

    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    public Geometry union() {
        return this.linearize().union();
    }

    public Geometry norm() {
        return this.linearize().norm();
    }

    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    public String toText() {
        return this.linearize().toText();
    }

    @Override
    public int getCoordinatesDimension() {
        return 2;
    }

    abstract class ArcScan {
        public ArcScan() {
            if (CircularString.this.controlPoints.length == 3) {
                CircularArc arc = new CircularArc(CircularString.this.controlPoints);
                this.visitArc(arc);
            } else {
                double[] arcControlPoints = new double[6];
                CircularArc arc = new CircularArc(arcControlPoints);
                for (int i = 0; i <= CircularString.this.controlPoints.length - 6; i += 4) {
                    System.arraycopy(CircularString.this.controlPoints, i, arcControlPoints, 0, 6);
                    arc.reset();
                    this.visitArc(arc);
                }
            }
        }

        protected abstract void visitArc(CircularArc var1);
    }
}

