/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;
import org.apache.commons.imaging.icc.IccProfileInfo;
import org.apache.commons.imaging.icc.IccProfileParser;
import org.apache.commons.imaging.util.IoUtils;

public abstract class Imaging {
    private static final int[] MAGIC_NUMBERS_GIF = new int[]{71, 73};
    private static final int[] MAGIC_NUMBERS_PNG = new int[]{137, 80};
    private static final int[] MAGIC_NUMBERS_JPEG = new int[]{255, 216};
    private static final int[] MAGIC_NUMBERS_BMP = new int[]{66, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_MOTOROLA = new int[]{77, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_INTEL = new int[]{73, 73};
    private static final int[] MAGIC_NUMBERS_PAM = new int[]{80, 55};
    private static final int[] MAGIC_NUMBERS_PSD = new int[]{56, 66};
    private static final int[] MAGIC_NUMBERS_PBM_A = new int[]{80, 49};
    private static final int[] MAGIC_NUMBERS_PBM_B = new int[]{80, 52};
    private static final int[] MAGIC_NUMBERS_PGM_A = new int[]{80, 50};
    private static final int[] MAGIC_NUMBERS_PGM_B = new int[]{80, 53};
    private static final int[] MAGIC_NUMBERS_PPM_A = new int[]{80, 51};
    private static final int[] MAGIC_NUMBERS_PPM_B = new int[]{80, 54};
    private static final int[] MAGIC_NUMBERS_JBIG2_1 = new int[]{151, 74};
    private static final int[] MAGIC_NUMBERS_JBIG2_2 = new int[]{66, 50};
    private static final int[] MAGIC_NUMBERS_ICNS = new int[]{105, 99};
    private static final int[] MAGIC_NUMBERS_DCX = new int[]{177, 104};
    private static final int[] MAGIC_NUMBERS_RGBE = new int[]{35, 63};

    public static boolean hasImageFileExtension(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        return Imaging.hasImageFileExtension(file.getName());
    }

    public static boolean hasImageFileExtension(String filename) {
        ImageParser[] imageParsers;
        if (filename == null) {
            return false;
        }
        filename = filename.toLowerCase(Locale.ENGLISH);
        for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
            String[] exts;
            for (String ext : exts = imageParser.getAcceptedExtensions()) {
                if (!filename.endsWith(ext.toLowerCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }

    public static ImageFormat guessFormat(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.guessFormat(new ByteSourceArray(bytes));
    }

    public static ImageFormat guessFormat(File file) throws ImageReadException, IOException {
        return Imaging.guessFormat(new ByteSourceFile(file));
    }

    private static boolean compareBytePair(int[] a, int[] b) {
        if (a.length != 2 && b.length != 2) {
            throw new RuntimeException("Invalid Byte Pair.");
        }
        return a[0] == b[0] && a[1] == b[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static ImageFormat guessFormat(ByteSource byteSource) throws ImageReadException, IOException {
        block38: {
            block40: {
                block39: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    block25: {
                                                                        block24: {
                                                                            block23: {
                                                                                if (byteSource == null) {
                                                                                    return ImageFormats.UNKNOWN;
                                                                                }
                                                                                is = null;
                                                                                canThrow = false;
                                                                                try {
                                                                                    is = byteSource.getInputStream();
                                                                                    i1 = is.read();
                                                                                    i2 = is.read();
                                                                                    if (i1 < 0 || i2 < 0) {
                                                                                        throw new ImageReadException("Couldn't read magic numbers to guess format.");
                                                                                    }
                                                                                    b1 = i1 & 255;
                                                                                    b2 = i2 & 255;
                                                                                    bytePair = new int[]{b1, b2};
                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_GIF, bytePair)) break block23;
                                                                                    canThrow = true;
                                                                                    var8_8 = ImageFormats.GIF;
                                                                                }
                                                                                catch (Throwable var14_32) {
                                                                                    IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                                    throw var14_32;
                                                                                }
                                                                                IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                                return var8_8;
                                                                            }
                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PNG, bytePair)) break block24;
                                                                            canThrow = true;
                                                                            var8_9 = ImageFormats.PNG;
                                                                            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                            return var8_9;
                                                                        }
                                                                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JPEG, bytePair)) break block25;
                                                                        canThrow = true;
                                                                        var8_10 = ImageFormats.JPEG;
                                                                        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                        return var8_10;
                                                                    }
                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_BMP, bytePair)) break block26;
                                                                    canThrow = true;
                                                                    var8_11 = ImageFormats.BMP;
                                                                    IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                    return var8_11;
                                                                }
                                                                if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_TIFF_MOTOROLA, bytePair)) break block27;
                                                                canThrow = true;
                                                                var8_12 = ImageFormats.TIFF;
                                                                IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                                return var8_12;
                                                            }
                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_TIFF_INTEL, bytePair)) break block28;
                                                            canThrow = true;
                                                            var8_13 = ImageFormats.TIFF;
                                                            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                            return var8_13;
                                                        }
                                                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PSD, bytePair)) break block29;
                                                        canThrow = true;
                                                        var8_14 = ImageFormats.PSD;
                                                        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                        return var8_14;
                                                    }
                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PAM, bytePair)) break block30;
                                                    canThrow = true;
                                                    var8_15 = ImageFormats.PAM;
                                                    IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                    return var8_15;
                                                }
                                                if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PBM_A, bytePair)) break block31;
                                                canThrow = true;
                                                var8_16 = ImageFormats.PBM;
                                                IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                                return var8_16;
                                            }
                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PBM_B, bytePair)) break block32;
                                            canThrow = true;
                                            var8_17 = ImageFormats.PBM;
                                            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                            return var8_17;
                                        }
                                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PGM_A, bytePair)) break block33;
                                        canThrow = true;
                                        var8_18 = ImageFormats.PGM;
                                        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                        return var8_18;
                                    }
                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PGM_B, bytePair)) break block34;
                                    canThrow = true;
                                    var8_19 = ImageFormats.PGM;
                                    IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                    return var8_19;
                                }
                                if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PPM_A, bytePair)) break block35;
                                canThrow = true;
                                var8_20 = ImageFormats.PPM;
                                IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                                return var8_20;
                            }
                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PPM_B, bytePair)) break block36;
                            canThrow = true;
                            var8_21 = ImageFormats.PPM;
                            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                            return var8_21;
                        }
                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JBIG2_1, bytePair)) ** GOTO lbl131
                        i3 = is.read();
                        i4 = is.read();
                        if (i3 < 0 || i4 < 0) {
                            throw new ImageReadException("Couldn't read magic numbers to guess format.");
                        }
                        b3 = i3 & 255;
                        b4 = i4 & 255;
                        bytePair2 = new int[]{b3, b4};
                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JBIG2_2, bytePair2)) break block37;
                        canThrow = true;
                        var13_31 = ImageFormats.JBIG2;
                        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                        return var13_31;
                    }
                    break block38;
lbl131:
                    // 1 sources

                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_ICNS, bytePair)) break block39;
                    canThrow = true;
                    var8_23 = ImageFormats.ICNS;
                    IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                    return var8_23;
                }
                if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_DCX, bytePair)) break block40;
                canThrow = true;
                var8_24 = ImageFormats.DCX;
                IoUtils.closeQuietly(canThrow, new Closeable[]{is});
                return var8_24;
            }
            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_RGBE, bytePair)) break block38;
            canThrow = true;
            var8_25 = ImageFormats.RGBE;
            IoUtils.closeQuietly(canThrow, new Closeable[]{is});
            return var8_25;
        }
        canThrow = true;
        var8_26 = ImageFormats.UNKNOWN;
        IoUtils.closeQuietly(canThrow, new Closeable[]{is});
        return var8_26;
    }

    public static ICC_Profile getICCProfile(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getICCProfile(bytes, null);
    }

    public static ICC_Profile getICCProfile(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getICCProfile(new ByteSourceArray(bytes), params);
    }

    public static ICC_Profile getICCProfile(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getICCProfile(is, filename, null);
    }

    public static ICC_Profile getICCProfile(InputStream is, String filename, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getICCProfile(new ByteSourceInputStream(is, filename), params);
    }

    public static ICC_Profile getICCProfile(File file) throws ImageReadException, IOException {
        return Imaging.getICCProfile(file, null);
    }

    public static ICC_Profile getICCProfile(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getICCProfile(new ByteSourceFile(file), params);
    }

    protected static ICC_Profile getICCProfile(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        byte[] bytes = Imaging.getICCProfileBytes(byteSource, params);
        if (bytes == null) {
            return null;
        }
        IccProfileParser parser = new IccProfileParser();
        IccProfileInfo info = parser.getICCProfileInfo(bytes);
        if (info == null) {
            return null;
        }
        if (info.issRGB()) {
            return null;
        }
        return ICC_Profile.getInstance(bytes);
    }

    public static byte[] getICCProfileBytes(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getICCProfileBytes(bytes, null);
    }

    public static byte[] getICCProfileBytes(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getICCProfileBytes(new ByteSourceArray(bytes), params);
    }

    public static byte[] getICCProfileBytes(File file) throws ImageReadException, IOException {
        return Imaging.getICCProfileBytes(file, null);
    }

    public static byte[] getICCProfileBytes(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getICCProfileBytes(new ByteSourceFile(file), params);
    }

    private static byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getICCProfileBytes(byteSource, params);
    }

    public static ImageInfo getImageInfo(String filename, byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceArray(filename, bytes), params);
    }

    public static ImageInfo getImageInfo(String filename, byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceArray(filename, bytes), null);
    }

    public static ImageInfo getImageInfo(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceInputStream(is, filename), null);
    }

    public static ImageInfo getImageInfo(InputStream is, String filename, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceInputStream(is, filename), params);
    }

    public static ImageInfo getImageInfo(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceArray(bytes), null);
    }

    public static ImageInfo getImageInfo(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceArray(bytes), params);
    }

    public static ImageInfo getImageInfo(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageInfo(new ByteSourceFile(file), params);
    }

    public static ImageInfo getImageInfo(File file) throws ImageReadException, IOException {
        return Imaging.getImageInfo(file, null);
    }

    private static ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getImageInfo(byteSource, params);
    }

    private static ImageParser getImageParser(ByteSource byteSource) throws ImageReadException, IOException {
        String filename;
        ImageFormat format = Imaging.guessFormat(byteSource);
        if (!format.equals(ImageFormats.UNKNOWN)) {
            ImageParser[] imageParsers;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptType(format)) continue;
                return imageParser;
            }
        }
        if ((filename = byteSource.getFilename()) != null) {
            ImageParser[] imageParsers;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptExtension(filename)) continue;
                return imageParser;
            }
        }
        throw new ImageReadException("Can't parse this format.");
    }

    public static Dimension getImageSize(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getImageSize(is, filename, null);
    }

    public static Dimension getImageSize(InputStream is, String filename, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageSize(new ByteSourceInputStream(is, filename), params);
    }

    public static Dimension getImageSize(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getImageSize(bytes, null);
    }

    public static Dimension getImageSize(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageSize(new ByteSourceArray(bytes), params);
    }

    public static Dimension getImageSize(File file) throws ImageReadException, IOException {
        return Imaging.getImageSize(file, null);
    }

    public static Dimension getImageSize(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getImageSize(new ByteSourceFile(file), params);
    }

    public static Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getImageSize(byteSource, params);
    }

    public static String getXmpXml(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getXmpXml(is, filename, null);
    }

    public static String getXmpXml(InputStream is, String filename, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getXmpXml(new ByteSourceInputStream(is, filename), params);
    }

    public static String getXmpXml(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getXmpXml(bytes, null);
    }

    public static String getXmpXml(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getXmpXml(new ByteSourceArray(bytes), params);
    }

    public static String getXmpXml(File file) throws ImageReadException, IOException {
        return Imaging.getXmpXml(file, null);
    }

    public static String getXmpXml(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getXmpXml(new ByteSourceFile(file), params);
    }

    public static String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getXmpXml(byteSource, params);
    }

    public static IImageMetadata getMetadata(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getMetadata(bytes, null);
    }

    public static IImageMetadata getMetadata(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getMetadata(new ByteSourceArray(bytes), params);
    }

    public static IImageMetadata getMetadata(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getMetadata(is, filename, null);
    }

    public static IImageMetadata getMetadata(InputStream is, String filename, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getMetadata(new ByteSourceInputStream(is, filename), params);
    }

    public static IImageMetadata getMetadata(File file) throws ImageReadException, IOException {
        return Imaging.getMetadata(file, null);
    }

    public static IImageMetadata getMetadata(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getMetadata(new ByteSourceFile(file), params);
    }

    private static IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getMetadata(byteSource, params);
    }

    public static String dumpImageFile(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.dumpImageFile(new ByteSourceArray(bytes));
    }

    public static String dumpImageFile(File file) throws ImageReadException, IOException {
        return Imaging.dumpImageFile(new ByteSourceFile(file));
    }

    private static String dumpImageFile(ByteSource byteSource) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.dumpImageFile(byteSource);
    }

    public static FormatCompliance getFormatCompliance(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getFormatCompliance(new ByteSourceArray(bytes));
    }

    public static FormatCompliance getFormatCompliance(File file) throws ImageReadException, IOException {
        return Imaging.getFormatCompliance(new ByteSourceFile(file));
    }

    private static FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getFormatCompliance(byteSource);
    }

    public static List<BufferedImage> getAllBufferedImages(InputStream is, String filename) throws ImageReadException, IOException {
        return Imaging.getAllBufferedImages(new ByteSourceInputStream(is, filename));
    }

    public static List<BufferedImage> getAllBufferedImages(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getAllBufferedImages(new ByteSourceArray(bytes));
    }

    public static List<BufferedImage> getAllBufferedImages(File file) throws ImageReadException, IOException {
        return Imaging.getAllBufferedImages(new ByteSourceFile(file));
    }

    private static List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        return imageParser.getAllBufferedImages(byteSource);
    }

    public static BufferedImage getBufferedImage(InputStream is) throws ImageReadException, IOException {
        return Imaging.getBufferedImage(is, null);
    }

    public static BufferedImage getBufferedImage(InputStream is, Map<String, Object> params) throws ImageReadException, IOException {
        String filename = null;
        if (params != null && params.containsKey("FILENAME")) {
            filename = (String)params.get("FILENAME");
        }
        return Imaging.getBufferedImage(new ByteSourceInputStream(is, filename), params);
    }

    public static BufferedImage getBufferedImage(byte[] bytes) throws ImageReadException, IOException {
        return Imaging.getBufferedImage(new ByteSourceArray(bytes), null);
    }

    public static BufferedImage getBufferedImage(byte[] bytes, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getBufferedImage(new ByteSourceArray(bytes), params);
    }

    public static BufferedImage getBufferedImage(File file) throws ImageReadException, IOException {
        return Imaging.getBufferedImage(new ByteSourceFile(file), null);
    }

    public static BufferedImage getBufferedImage(File file, Map<String, Object> params) throws ImageReadException, IOException {
        return Imaging.getBufferedImage(new ByteSourceFile(file), params);
    }

    private static BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageParser imageParser = Imaging.getImageParser(byteSource);
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        return imageParser.getBufferedImage(byteSource, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(BufferedImage src, File file, ImageFormat format, Map<String, Object> params) throws ImageWriteException, IOException {
        OutputStream os = null;
        boolean canThrow = false;
        try {
            os = new FileOutputStream(file);
            os = new BufferedOutputStream(os);
            Imaging.writeImage(src, os, format, params);
            canThrow = true;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, os);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, os);
    }

    public static byte[] writeImageToBytes(BufferedImage src, ImageFormat format, Map<String, Object> params) throws ImageWriteException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Imaging.writeImage(src, os, format, params);
        return os.toByteArray();
    }

    public static void writeImage(BufferedImage src, OutputStream os, ImageFormat format, Map<String, Object> params) throws ImageWriteException, IOException {
        ImageParser[] imageParsers = ImageParser.getAllImageParsers();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("FORMAT", format);
        ImageParser imageParser = null;
        for (ImageParser imageParser2 : imageParsers) {
            if (!imageParser2.canAcceptType(format)) continue;
            imageParser = imageParser2;
            break;
        }
        if (imageParser == null) {
            throw new ImageWriteException("Unknown Format: " + format);
        }
        imageParser.writeImage(src, os, params);
    }
}

