/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.RelationMemberEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class WrongTurnRestrictionLegTypeError
extends Issue {
    private TurnRestrictionLegRole role;
    private OsmPrimitive leg;

    public WrongTurnRestrictionLegTypeError(IssuesModel parent, TurnRestrictionLegRole role, OsmPrimitive leg) {
        super(parent, Severity.ERROR);
        this.role = role;
        this.leg = leg;
        this.actions.add(new DeleteAction());
        this.actions.add(new FixInEditorAction());
    }

    @Override
    public String getText() {
        String msg = null;
        switch (this.leg.getType()) {
            case NODE: {
                msg = I18n.tr((String)"This turn restriction uses the node <span class=\"object-name\">{0}</span> as member with role <tt>{1}</tt>.", (Object[])new Object[]{this.leg.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.toString()});
                break;
            }
            case RELATION: {
                msg = I18n.tr((String)"This turn restriction uses the relation <span class=\"object-name\">{0}</span> as member with role <tt>{1}</tt>.", (Object[])new Object[]{this.leg.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.toString()});
            }
        }
        return msg + " " + I18n.tr((String)"A way is required instead.", (Object[])new Object[0]);
    }

    class FixInEditorAction
    extends AbstractAction {
        public FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Change to the Basic Editor and select a way", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigationControler controler = WrongTurnRestrictionLegTypeError.this.getIssuesModel().getNavigationControler();
            switch (WrongTurnRestrictionLegTypeError.this.role) {
                case FROM: {
                    controler.gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.FROM);
                    break;
                }
                case TO: {
                    controler.gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.TO);
                }
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", I18n.tr((String)"Delete", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Delete the member from the turn restriction", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationMemberEditorModel model = WrongTurnRestrictionLegTypeError.this.getIssuesModel().getEditorModel().getRelationMemberEditorModel();
            switch (WrongTurnRestrictionLegTypeError.this.role) {
                case FROM: {
                    model.setFromPrimitive(null);
                    break;
                }
                case TO: {
                    model.setToPrimitive(null);
                }
            }
        }
    }
}

