/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.citoyennete;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class MairieHandler
extends ToulouseDataSetHandler {
    public MairieHandler() {
        this(12554, "Mairies");
        this.setCategory(CAT_CITOYENNETE);
    }

    protected MairieHandler(int portalId, String wikiPage) {
        super(portalId, "amenity=townhall");
        this.setWikiPage(wikiPage);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Mairie"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            this.replace((IPrimitive)n, "Mairie", "name");
            n.put("amenity", "townhall");
            this.replaceOpeningHours((OsmPrimitive)n, "Horaire_ouverture");
            n.remove("INSEE");
            n.remove("Libelle");
            this.replacePhone((OsmPrimitive)n, "Telephone");
            n.remove("Type");
        }
    }
}

