/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.util.CollectionUtils;

public class Cell<D extends ODDocument>
extends TableCalcNode<CellStyle, D> {
    private static final Pattern multiSpacePattern = Pattern.compile("[\t\r\n ]+");
    private static boolean OO_MODE = true;
    private final Row<D> row;

    public static boolean getTextValueMode() {
        return OO_MODE;
    }

    Cell(Row<D> row, Element element) {
        super(row.getODDocument(), element, CellStyle.class);
        this.row = row;
    }

    protected final Row<D> getRow() {
        return this.row;
    }

    protected final XMLVersion getNS() {
        return this.getODDocument().getVersion();
    }

    protected final Namespace getValueNS() {
        XMLVersion xMLVersion = this.getNS();
        return xMLVersion == XMLVersion.OD ? xMLVersion.getOFFICE() : xMLVersion.getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    public final ODValueType getValueType() {
        String string = this.getType();
        return string == null ? null : ODValueType.get(string);
    }

    @Override
    protected String getStyleName() {
        throw new UnsupportedOperationException("cannot resolve our style, use MutableCell");
    }

    private final String getValue(String string) {
        return this.getElement().getAttributeValue(string, this.getValueNS());
    }

    public Object getValue() {
        ODValueType oDValueType = this.getValueType();
        if (oDValueType == null || oDValueType == ODValueType.STRING) {
            String string;
            String string2 = string = oDValueType == null ? null : this.getValue(oDValueType.getValueAttribute());
            if (string != null) {
                return string;
            }
            return this.getTextValue();
        }
        return oDValueType.parse(this.getValue(oDValueType.getValueAttribute()));
    }

    public String getTextValue() {
        return this.getTextValue(Cell.getTextValueMode());
    }

    public String getTextValue(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : this.getElement().getChildren()) {
            Element element = (Element)e;
            if (!element.getName().equals("p") && !element.getName().equals("h") || !element.getNamespacePrefix().equals("text")) continue;
            arrayList.add(this.getStringValue(element, bl));
        }
        return CollectionUtils.join(arrayList, "\n");
    }

    private String getStringValue(Element element, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Namespace namespace = element.getNamespace();
        boolean bl2 = false;
        Iterator iterator = element.getDescendants();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof Text) {
                object = multiSpacePattern.matcher(((Text)e).getText()).replaceAll(" ");
                if (!bl && ((String)object).startsWith(" ") && (bl2 || stringBuilder.length() == 0)) {
                    stringBuilder.append(((String)object).substring(1));
                } else {
                    stringBuilder.append((String)object);
                }
                bl2 = ((String)object).endsWith(" ");
                continue;
            }
            if (!(e instanceof Element)) continue;
            object = (Element)e;
            if (object.getName().equals("tab") && object.getNamespace().equals((Object)namespace)) {
                stringBuilder.append("\t");
                continue;
            }
            if (object.getName().equals("line-break") && object.getNamespace().equals((Object)namespace)) {
                stringBuilder.append("\n");
                continue;
            }
            if (!object.getName().equals("s") || !object.getNamespace().equals((Object)namespace)) continue;
            int n = Integer.valueOf(object.getAttributeValue("c", namespace, "1"));
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            stringBuilder.append(cArray);
        }
        if (!bl && bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

