/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class MulBlankRecord
extends StandardRecord {
    public static final short sid = 190;
    private final int _row;
    private final int _firstCol;
    private final short[] _xfs;
    private final int _lastCol;

    public MulBlankRecord(int n, int n2, short[] sArray) {
        this._row = n;
        this._firstCol = n2;
        this._xfs = sArray;
        this._lastCol = n2 + sArray.length - 1;
    }

    public int getRow() {
        return this._row;
    }

    public int getFirstColumn() {
        return this._firstCol;
    }

    public int getNumColumns() {
        return this._lastCol - this._firstCol + 1;
    }

    public short getXFAt(int n) {
        return this._xfs[n];
    }

    public MulBlankRecord(RecordInputStream recordInputStream) {
        this._row = recordInputStream.readUShort();
        this._firstCol = recordInputStream.readShort();
        this._xfs = MulBlankRecord.parseXFs(recordInputStream);
        this._lastCol = recordInputStream.readShort();
    }

    private static short[] parseXFs(RecordInputStream recordInputStream) {
        short[] sArray = new short[(recordInputStream.remaining() - 2) / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = recordInputStream.readShort();
        }
        return sArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MULBLANK]\n");
        stringBuffer.append("row  = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        stringBuffer.append(" lastcol  = ").append(Integer.toHexString(this._lastCol)).append("\n");
        for (int i = 0; i < this.getNumColumns(); ++i) {
            stringBuffer.append("xf").append(i).append("\t\t= ").append(Integer.toHexString(this.getXFAt(i))).append("\n");
        }
        stringBuffer.append("[/MULBLANK]\n");
        return stringBuffer.toString();
    }

    @Override
    public short getSid() {
        return 190;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._row);
        littleEndianOutput.writeShort(this._firstCol);
        int n = this._xfs.length;
        for (int i = 0; i < n; ++i) {
            littleEndianOutput.writeShort(this._xfs[i]);
        }
        littleEndianOutput.writeShort(this._lastCol);
    }

    @Override
    protected int getDataSize() {
        return 6 + this._xfs.length * 2;
    }

    @Override
    public Object clone() {
        return this;
    }
}

