/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;

public class MultiHashMap
extends HashMap
implements MultiMap {
    private transient Collection values = null;
    private static final long serialVersionUID = 1943563828307035349L;

    public MultiHashMap() {
    }

    public MultiHashMap(int n) {
        super(n);
    }

    public MultiHashMap(int n, float f) {
        super(n, f);
    }

    public MultiHashMap(Map map) {
        super((int)((float)map.size() * 1.4f));
        this.putAll(map);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = "1.2";
        try {
            string = System.getProperty("java.version");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.startsWith("1.2") || string.startsWith("1.3")) {
            for (Map.Entry entry : this.entrySet()) {
                super.put(entry.getKey(), ((Collection)entry.getValue()).iterator().next());
            }
        }
    }

    public int totalSize() {
        int n = 0;
        Collection collection = super.values();
        for (Collection collection2 : collection) {
            n += collection2.size();
        }
        return n;
    }

    public Collection getCollection(Object object) {
        return (Collection)this.get(object);
    }

    public int size(Object object) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public Iterator iterator(Object object) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return EmptyIterator.INSTANCE;
        }
        return collection.iterator();
    }

    @Override
    public Object put(Object object, Object object2) {
        boolean bl;
        Collection collection = this.getCollection(object);
        if (collection == null) {
            collection = this.createCollection(null);
            super.put(object, collection);
        }
        return (bl = collection.add(object2)) ? object2 : null;
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            for (Map.Entry entry : map.entrySet()) {
                Collection collection = (Collection)entry.getValue();
                this.putAll(entry.getKey(), collection);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean putAll(Object object, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Collection collection2 = this.getCollection(object);
        if (collection2 == null) {
            collection2 = this.createCollection(collection);
            if (collection2.size() == 0) {
                return false;
            }
            super.put(object, collection2);
            return true;
        }
        return collection2.addAll(collection);
    }

    @Override
    public boolean containsValue(Object object) {
        Set set = super.entrySet();
        if (set == null) {
            return false;
        }
        for (Map.Entry entry : set) {
            Collection collection = (Collection)entry.getValue();
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object object, Object object2) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return false;
        }
        return collection.contains(object2);
    }

    @Override
    public Object remove(Object object, Object object2) {
        Collection collection = this.getCollection(object);
        if (collection == null) {
            return null;
        }
        boolean bl = collection.remove(object2);
        if (!bl) {
            return null;
        }
        if (collection.isEmpty()) {
            this.remove(object);
        }
        return object2;
    }

    @Override
    public void clear() {
        Set set = super.entrySet();
        for (Map.Entry entry : set) {
            Collection collection = (Collection)entry.getValue();
            collection.clear();
        }
        super.clear();
    }

    @Override
    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    Iterator superValuesIterator() {
        return super.values().iterator();
    }

    @Override
    public Object clone() {
        MultiHashMap multiHashMap = (MultiHashMap)super.clone();
        for (Map.Entry entry : multiHashMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Collection collection2 = this.createCollection(collection);
            entry.setValue(collection2);
        }
        return multiHashMap;
    }

    protected Collection createCollection(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList(collection);
    }

    private class ValueIterator
    implements Iterator {
        private Iterator backedIterator;
        private Iterator tempIterator;

        private ValueIterator() {
            this.backedIterator = MultiHashMap.this.superValuesIterator();
        }

        private boolean searchNextIterator() {
            while (this.tempIterator == null || !this.tempIterator.hasNext()) {
                if (!this.backedIterator.hasNext()) {
                    return false;
                }
                this.tempIterator = ((Collection)this.backedIterator.next()).iterator();
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.searchNextIterator();
        }

        public Object next() {
            if (!this.searchNextIterator()) {
                throw new NoSuchElementException();
            }
            return this.tempIterator.next();
        }

        @Override
        public void remove() {
            if (this.tempIterator == null) {
                throw new IllegalStateException();
            }
            this.tempIterator.remove();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        @Override
        public void clear() {
            MultiHashMap.this.clear();
        }
    }
}

