/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class MemberDescriptorSpecializer
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = true;
    private final MemberVisitor extraParameterMemberVisitor;

    public MemberDescriptorSpecializer() {
        this(null);
    }

    public MemberDescriptorSpecializer(MemberVisitor memberVisitor) {
        this.extraParameterMemberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz clazz;
        Value value = StoringInvocationUnit.getFieldValue(programField);
        if (value.computationalType() == 5 && programField.referencedClass != (clazz = value.referenceValue().getReferencedClass())) {
            System.out.println("MemberDescriptorSpecializer: " + programClass.getName() + "." + programField.getName(programClass) + " " + programField.getDescriptor(programClass));
            System.out.println("  " + programField.referencedClass.getName() + " -> " + clazz.getName());
            programField.referencedClass = clazz;
            if (this.extraParameterMemberVisitor != null) {
                this.extraParameterMemberVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
        int n2 = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass));
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            Value value = StoringInvocationUnit.getMethodParameterValue(programMethod, i);
            if (value.computationalType() != 5) continue;
            Clazz clazz = value.referenceValue().getReferencedClass();
            if (programMethod.referencedClasses[n3] != clazz) {
                System.out.println("MemberDescriptorSpecializer: " + programClass.getName() + "." + programMethod.getName(programClass) + programMethod.getDescriptor(programClass));
                System.out.println("  " + programMethod.referencedClasses[n3].getName() + " -> " + clazz.getName());
                programMethod.referencedClasses[n3] = clazz;
                if (this.extraParameterMemberVisitor != null) {
                    this.extraParameterMemberVisitor.visitProgramMethod(programClass, programMethod);
                }
            }
            ++n3;
        }
    }
}

