/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);

    public EvaluationSimplifier() {
        this(new PartialEvaluator(), null);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while simplifying instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n);
        for (int i = 0; i < n; ++i) {
            if (!this.partialEvaluator.isTraced(i)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, i);
            instruction.accept(clazz, method, codeAttribute, i, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -128: 
            case -126: 
            case -120: 
            case -117: 
            case -114: 
            case -111: 
            case -110: 
            case -109: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                this.replaceIntegerPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case -127: 
            case -125: 
            case -123: 
            case -116: 
            case -113: 
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                this.replaceLongPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case -122: 
            case -119: 
            case -112: 
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                this.replaceFloatPushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case -121: 
            case -118: 
            case -115: 
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                this.replaceDoublePushInstruction(clazz, n, simpleInstruction);
                break;
            }
            case 50: {
                this.replaceReferencePushInstruction(clazz, n, simpleInstruction);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.replaceIntegerPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.replaceLongPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.replaceFloatPushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.replaceDoublePushInstruction(clazz, n, variableInstruction, n2);
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.replaceReferencePushInstruction(clazz, n, variableInstruction);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.deleteReferencePopInstruction(clazz, n, variableInstruction);
                break;
            }
            case -87: {
                this.replaceBranchInstruction(clazz, n, variableInstruction);
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -76: {
                this.replaceAnyPushInstruction(clazz, n, constantInstruction);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                if (constantInstruction.stackPushCount(clazz) <= 0 || this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, constantInstruction)) break;
                this.replaceAnyPushInstruction(clazz, n, constantInstruction);
                break;
            }
            case -64: {
                this.replaceReferencePushInstruction(clazz, n, constantInstruction);
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -89: 
            case -56: {
                break;
            }
            case -88: 
            case -55: {
                this.replaceJsrInstruction(clazz, n, branchInstruction);
                break;
            }
            default: {
                this.replaceBranchInstruction(clazz, n, branchInstruction);
            }
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        this.replaceBranchInstruction(clazz, n, switchInstruction);
        if (!this.codeAttributeEditor.isModified(n)) {
            this.replaceSwitchInstruction(clazz, n, switchInstruction);
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int n, Instruction instruction) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            switch (value.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, n, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, n, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, n, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, n, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, n, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            int n3 = value.integerValue().value();
            if (n3 << 16 >> 16 == n3) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)17, n3);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction instruction2 = new ConstantInstruction(18, constantPoolEditor.addIntegerConstant(n3)).shrink();
                this.replaceInstruction(clazz, n, instruction, instruction2);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)21, i);
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            long l = value.longValue().value();
            if (l == 0L || l == 1L) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)9, (int)l);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction instruction2 = new ConstantInstruction(20, constantPoolEditor.addLongConstant(l)).shrink();
                this.replaceInstruction(clazz, n, instruction, instruction2);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)22, i);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            float f = value.floatValue().value();
            if (f == 0.0f || f == 1.0f || f == 2.0f) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)11, (int)f);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction instruction2 = new ConstantInstruction(18, constantPoolEditor.addFloatConstant(f)).shrink();
                this.replaceInstruction(clazz, n, instruction, instruction2);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)23, i);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            double d = value.doubleValue().value();
            if (d == 0.0 || d == 1.0) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)14, (int)d);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                Instruction instruction2 = new ConstantInstruction(20, constantPoolEditor.addDoubleConstant(d)).shrink();
                this.replaceInstruction(clazz, n, instruction, instruction2);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)24, i);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int n, Instruction instruction) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            this.replaceConstantPushInstruction(clazz, n, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        Instruction instruction2 = new SimpleInstruction(by, n2).shrink();
        this.replaceInstruction(clazz, n, instruction, instruction2);
    }

    private void replaceVariablePushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        Instruction instruction2 = new VariableInstruction(by, n2).shrink();
        this.replaceInstruction(clazz, n, instruction, instruction2);
    }

    private void replaceJsrInstruction(Clazz clazz, int n, BranchInstruction branchInstruction) {
        int n2 = n + branchInstruction.branchOffset;
        if (!this.partialEvaluator.isSubroutineReturning(n2) || this.partialEvaluator.branchOrigins(n2).instructionOffsetCount() == 1) {
            this.replaceBranchInstruction(clazz, n, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(n + branchInstruction.length(n))) {
            this.replaceByInfiniteLoop(clazz, n + branchInstruction.length(n), branchInstruction);
        }
    }

    private void deleteReferencePopInstruction(Clazz clazz, int n, Instruction instruction) {
        if (this.partialEvaluator.isSubroutineStart(n) && (!this.partialEvaluator.isSubroutineReturning(n) || this.partialEvaluator.branchOrigins(n).instructionOffsetCount() == 1)) {
            this.codeAttributeEditor.deleteInstruction(n);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int n, Instruction instruction) {
        int n2;
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        if (instructionOffsetValue != null && instructionOffsetValue.instructionOffsetCount() == 1 && (n2 = instructionOffsetValue.instructionOffset(0) - n) != instruction.length(n)) {
            Instruction instruction2 = new BranchInstruction(-56, n2).shrink();
            this.replaceInstruction(clazz, n, instruction, instruction2);
        }
    }

    private void replaceSwitchInstruction(Clazz clazz, int n, SwitchInstruction switchInstruction) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        int n2 = instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1) - n;
        SwitchInstruction switchInstruction2 = null;
        int[] nArray = switchInstruction.jumpOffsets;
        for (int i = 0; i < nArray.length; ++i) {
            if (instructionOffsetValue.contains(n + nArray[i])) continue;
            nArray[i] = n2;
            switchInstruction2 = switchInstruction;
        }
        if (!instructionOffsetValue.contains(n + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = n2;
            switchInstruction2 = switchInstruction;
        }
        if (switchInstruction2 != null) {
            this.replaceInstruction(clazz, n, switchInstruction, switchInstruction2);
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n, Instruction instruction) {
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int n, Instruction instruction, Instruction instruction2) {
        int n2 = instruction.stackPopCount(clazz) - instruction2.stackPopCount(clazz);
        this.insertPopInstructions(n, n2);
        this.codeAttributeEditor.replaceInstruction(n, instruction2);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, n, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
                break;
            }
            default: {
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (int i = 0; i < n2 / 2; ++i) {
                    instructionArray[i] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(n, instructionArray);
            }
        }
    }
}

