/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSImporterAction;
import public_transport.GTFSStopTableModel;
import public_transport.TransText;

public class GTFSImporterDialog {
    private JDialog jDialog = null;
    private JTabbedPane tabbedPane = null;
    private JComboBox<TransText> cbStoptype = null;
    private JList tracksList = null;
    private JTextField tfGPSTimeStart = null;
    private JTextField tfStopwatchStart = null;
    private JTextField tfTimeWindow = null;
    private JTextField tfThreshold = null;
    private JTable stoplistTable = null;
    private JTable gtfsStopTable = null;
    private final String[] stoptypes = new String[]{I18n.marktr((String)"bus"), I18n.marktr((String)"tram"), I18n.marktr((String)"light_rail"), I18n.marktr((String)"subway"), I18n.marktr((String)"rail")};

    public GTFSImporterDialog(GTFSImporterAction controller) {
        Frame frame = JOptionPane.getFrameForComponent(Main.parent);
        this.jDialog = new JDialog(frame, I18n.tr((String)"Create Stops from GTFS", (Object[])new Object[0]), false);
        this.tabbedPane = new JTabbedPane();
        JPanel tabSettings = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Settings", (Object[])new Object[0]), tabSettings);
        JPanel tabWaypoints = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"GTFS-Stops", (Object[])new Object[0]), tabWaypoints);
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setEnabledAt(1, true);
        this.jDialog.add(this.tabbedPane);
        JPanel contentPane = tabSettings;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        JLabel label = new JLabel(I18n.tr((String)"Type of stops to add", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.cbStoptype = new JComboBox();
        this.cbStoptype.setEditable(false);
        for (String type : this.stoptypes) {
            this.cbStoptype.addItem(new TransText(type));
        }
        this.cbStoptype.setActionCommand("gtfsImporter.settingsStoptype");
        this.cbStoptype.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.cbStoptype, layoutCons);
        contentPane.add(this.cbStoptype);
        label = new JLabel(I18n.tr((String)"Time on your GPS device", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.tfGPSTimeStart = new JTextField("00:00:00", 15);
        this.tfGPSTimeStart.setActionCommand("gtfsImporter.settingsGPSTimeStart");
        this.tfGPSTimeStart.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 3;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfGPSTimeStart, layoutCons);
        contentPane.add(this.tfGPSTimeStart);
        label = new JLabel(I18n.tr((String)"HH:MM:SS.sss", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 3;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Time on your stopwatch", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 4;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.tfStopwatchStart = new JTextField("00:00:00", 15);
        this.tfStopwatchStart.setActionCommand("gtfsImporter.settingsStopwatchStart");
        this.tfStopwatchStart.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 5;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfStopwatchStart, layoutCons);
        contentPane.add(this.tfStopwatchStart);
        label = new JLabel(I18n.tr((String)"HH:MM:SS.sss", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 5;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Time window", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 6;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.tfTimeWindow = new JTextField("15", 4);
        this.tfTimeWindow.setActionCommand("gtfsImporter.settingsTimeWindow");
        this.tfTimeWindow.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 7;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfTimeWindow, layoutCons);
        contentPane.add(this.tfTimeWindow);
        label = new JLabel(I18n.tr((String)"seconds", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 7;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Move Threshold", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 8;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        this.tfThreshold = new JTextField("20", 4);
        this.tfThreshold.setActionCommand("gtfsImporter.settingsThreshold");
        this.tfThreshold.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 9;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfThreshold, layoutCons);
        contentPane.add(this.tfThreshold);
        label = new JLabel(I18n.tr((String)"meters", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 9;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        JButton bSuggestStops = new JButton(I18n.tr((String)"Suggest Stops", (Object[])new Object[0]));
        bSuggestStops.setActionCommand("gtfsImporter.settingsSuggestStops");
        bSuggestStops.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 10;
        layoutCons.gridwidth = 3;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bSuggestStops, layoutCons);
        contentPane.add(bSuggestStops);
        contentPane = tabWaypoints;
        gridbag = new GridBagLayout();
        layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt N"), "gtfsImporter.gtfsStopsFocusAdd");
        contentPane.getActionMap().put("gtfsImporter.gtfsStopsFocusAdd", controller.getFocusAddAction());
        this.gtfsStopTable = new JTable();
        JScrollPane tableSP = new JScrollPane(this.gtfsStopTable);
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 4;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 1.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(tableSP, layoutCons);
        contentPane.add(tableSP);
        JButton bFind = new JButton(I18n.tr((String)"Find", (Object[])new Object[0]));
        bFind.setActionCommand("gtfsImporter.gtfsStopsFind");
        bFind.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bFind, layoutCons);
        contentPane.add(bFind);
        JButton bShow = new JButton(I18n.tr((String)"Show", (Object[])new Object[0]));
        bShow.setActionCommand("gtfsImporter.gtfsStopsShow");
        bShow.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bShow, layoutCons);
        contentPane.add(bShow);
        JButton bMark = new JButton(I18n.tr((String)"Mark", (Object[])new Object[0]));
        bMark.setActionCommand("gtfsImporter.gtfsStopsMark");
        bMark.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 1;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bMark, layoutCons);
        contentPane.add(bMark);
        JButton bCatch = new JButton(I18n.tr((String)"Catch", (Object[])new Object[0]));
        bCatch.setActionCommand("gtfsImporter.gtfsStopsCatch");
        bCatch.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bCatch, layoutCons);
        contentPane.add(bCatch);
        JButton bJoin = new JButton(I18n.tr((String)"Join", (Object[])new Object[0]));
        bJoin.setActionCommand("gtfsImporter.gtfsStopsJoin");
        bJoin.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 2;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bJoin, layoutCons);
        contentPane.add(bJoin);
        JButton bAdd = new JButton(I18n.tr((String)"Enable", (Object[])new Object[0]));
        bAdd.setActionCommand("gtfsImporter.gtfsStopsAdd");
        bAdd.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 3;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bAdd, layoutCons);
        contentPane.add(bAdd);
        JButton bDelete = new JButton(I18n.tr((String)"Disable", (Object[])new Object[0]));
        bDelete.setActionCommand("gtfsImporter.gtfsStopsDelete");
        bDelete.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 3;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bDelete, layoutCons);
        contentPane.add(bDelete);
        this.jDialog.pack();
        this.jDialog.setLocationRelativeTo(frame);
    }

    public void setTrackValid(boolean valid) {
        this.tabbedPane.setEnabledAt(2, valid);
    }

    public void setVisible(boolean visible) {
        this.jDialog.setVisible(visible);
    }

    public void setSettings(String gpsSyncTime, String stopwatchStart, double timeWindow, double threshold) {
        this.tfGPSTimeStart.setText(gpsSyncTime);
        this.tfStopwatchStart.setText(stopwatchStart);
        this.tfTimeWindow.setText(Double.toString(timeWindow));
        this.tfThreshold.setText(Double.toString(threshold));
    }

    public String getStoptype() {
        return ((TransText)this.cbStoptype.getSelectedItem()).text;
    }

    public boolean gpsTimeStartValid() {
        if (GTFSImporterDialog.parseTime(this.tfGPSTimeStart.getText()) >= 0.0) {
            return true;
        }
        JOptionPane.showMessageDialog(null, I18n.tr((String)"Can''t parse a time from this string.", (Object[])new Object[0]), I18n.tr((String)"Invalid value", (Object[])new Object[0]), 0);
        return false;
    }

    public String getGpsTimeStart() {
        return this.tfGPSTimeStart.getText();
    }

    public void setGpsTimeStart(String s) {
        this.tfGPSTimeStart.setText(s);
    }

    public boolean stopwatchStartValid() {
        if (GTFSImporterDialog.parseTime(this.tfStopwatchStart.getText()) >= 0.0) {
            return true;
        }
        JOptionPane.showMessageDialog(null, I18n.tr((String)"Can''t parse a time from this string.", (Object[])new Object[0]), I18n.tr((String)"Invalid value", (Object[])new Object[0]), 0);
        return false;
    }

    public String getStopwatchStart() {
        return this.tfStopwatchStart.getText();
    }

    public void setStopwatchStart(String s) {
        this.tfStopwatchStart.setText(s);
    }

    public double getTimeWindow() {
        return Double.parseDouble(this.tfTimeWindow.getText());
    }

    public double getThreshold() {
        return Double.parseDouble(this.tfThreshold.getText());
    }

    public JTable getGTFSStopTable() {
        return this.gtfsStopTable;
    }

    public void setGTFSStopTableModel(GTFSStopTableModel model) {
        this.gtfsStopTable.setModel(model);
        int width = this.gtfsStopTable.getPreferredSize().width;
        this.gtfsStopTable.getColumnModel().getColumn(0).setPreferredWidth((int)((double)width * 0.3));
        this.gtfsStopTable.getColumnModel().getColumn(1).setPreferredWidth((int)((double)width * 0.6));
        this.gtfsStopTable.getColumnModel().getColumn(2).setPreferredWidth((int)((double)width * 0.1));
    }

    public static double parseTime(String s) {
        if (s.charAt(2) != ':' || s.charAt(2) != ':' || s.length() < 8) {
            return -1.0;
        }
        int hour = Integer.parseInt(s.substring(0, 2));
        int minute = Integer.parseInt(s.substring(3, 5));
        double second = Double.parseDouble(s.substring(6, s.length()));
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0.0 || second >= 60.0) {
            return -1.0;
        }
        return second + (double)(minute * 60) + (double)(hour * 60 * 60);
    }
}

