/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.Atomic;
import org.mapdb.Fun;

public final class Bind {
    private Bind() {
    }

    public static <K2, K1> Iterable<K1> findSecondaryKeys(final NavigableSet<Fun.Tuple2<K2, K1>> secondaryKeys, final K2 secondaryKey) {
        return new Iterable<K1>(){

            @Override
            public Iterator<K1> iterator() {
                final Iterator iter = secondaryKeys.subSet(Fun.t2(secondaryKey, null), Fun.t2(secondaryKey, Fun.HI)).iterator();
                return new Iterator<K1>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K1 next() {
                        return ((Fun.Tuple2)iter.next()).b;
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    public static <K, V> void size(MapWithModificationListener<K, V> map, final Atomic.Long size) {
        if (size.get() == 0L && map.isEmpty()) {
            size.set(map.size());
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(Object key, Object oldVal, Object newVal) {
                if (oldVal == null && newVal != null) {
                    size.incrementAndGet();
                } else if (oldVal != null && newVal == null) {
                    size.decrementAndGet();
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValue(MapWithModificationListener<K, V> map, final Map<K, V2> secondary, final Fun.Function2<V2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(e.getKey(), fun.run(e.getKey(), e.getValue()));
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(key);
                } else {
                    secondary.put(key, fun.run(key, newVal));
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final NavigableSet<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.add(Fun.t2(fun.run(e.getKey(), e.getValue()), e.getKey()));
            }
        }
        map.addModificationListener(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(Fun.t2(fun.run(key, oldVal), key));
                } else if (oldVal == null) {
                    secondary.add(Fun.t2(fun.run(key, newVal), key));
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(Fun.t2(oldKey, key));
                    secondary.add(Fun.t2(newKey, key));
                }
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, NavigableSet<Fun.Tuple2<V, K>> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V, C> void histogram(MapWithModificationListener<K, V> primary, final ConcurrentMap<C, Long> histogram, final Fun.Function2<C, K, V> entryToCategory) {
        MapListener listener = new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    Object category = entryToCategory.run(key, oldVal);
                    this.incrementHistogram(category, -1L);
                } else if (oldVal == null) {
                    Object category = entryToCategory.run(key, newVal);
                    this.incrementHistogram(category, 1L);
                } else {
                    Object newCat;
                    Object oldCat = entryToCategory.run(key, oldVal);
                    if (oldCat == (newCat = entryToCategory.run(key, newVal)) || oldCat.equals(newCat)) {
                        return;
                    }
                    this.incrementHistogram(oldCat, -1L);
                    this.incrementHistogram(oldCat, 1L);
                }
            }

            private void incrementHistogram(C category, long i) {
                Long newCount;
                Long oldCount;
                while (!((oldCount = (Long)histogram.get(category)) == null ? histogram.putIfAbsent(category, i) == null : histogram.replace(category, oldCount, newCount = Long.valueOf(oldCount + i)))) {
                }
            }
        };
        primary.addModificationListener(listener);
    }

    public static interface MapWithModificationListener<K, V>
    extends Map<K, V> {
        public void addModificationListener(MapListener<K, V> var1);

        public void removeModificationListener(MapListener<K, V> var1);
    }

    public static interface MapListener<K, V> {
        public void update(K var1, V var2, V var3);
    }
}

