/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EquidistantAzimuthalProjection
extends AzimuthalProjection {
    private static final double TOL = 1.0E-8;
    private int mode;
    private double[] en;
    private double M1;
    private double N1;
    private double Mp;
    private double He;
    private double G;
    private double sinphi0;
    private double cosphi0;

    public EquidistantAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public EquidistantAzimuthalProjection(double projectionLatitude, double projectionLongitude) {
        super(projectionLatitude, projectionLongitude);
        this.initialize();
    }

    @Override
    public Object clone() {
        EquidistantAzimuthalProjection p = (EquidistantAzimuthalProjection)super.clone();
        if (this.en != null) {
            p.en = (double[])this.en.clone();
        }
        return p;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            this.mode = this.projectionLatitude < 0.0 ? 2 : 1;
            this.sinphi0 = this.projectionLatitude < 0.0 ? -1.0 : 1.0;
            this.cosphi0 = 0.0;
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 3;
            this.sinphi0 = 0.0;
            this.cosphi0 = 1.0;
        } else {
            this.mode = 4;
            this.sinphi0 = Math.sin(this.projectionLatitude);
            this.cosphi0 = Math.cos(this.projectionLatitude);
        }
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            switch (this.mode) {
                case 1: {
                    this.Mp = ProjectionMath.mlfn(1.5707963267948966, 1.0, 0.0, this.en);
                    break;
                }
                case 2: {
                    this.Mp = ProjectionMath.mlfn(-1.5707963267948966, -1.0, 0.0, this.en);
                    break;
                }
                case 3: 
                case 4: {
                    this.N1 = 1.0 / Math.sqrt(1.0 - this.es * this.sinphi0 * this.sinphi0);
                    this.He = this.e / Math.sqrt(this.one_es);
                    this.G = this.sinphi0 * this.He;
                    this.He *= this.cosphi0;
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        if (this.spherical) {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lam);
            switch (this.mode) {
                case 3: 
                case 4: {
                    xy.y = this.mode == 3 ? cosphi * coslam : this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (Math.abs(Math.abs(xy.y) - 1.0) < 1.0E-8) {
                        if (xy.y < 0.0) {
                            throw new ProjectionException();
                        }
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    xy.y = Math.acos(xy.y);
                    xy.y /= Math.sin(xy.y);
                    xy.x = xy.y * cosphi * Math.sin(lam);
                    xy.y = xy.y * (this.mode == 3 ? sinphi : this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam);
                    break;
                }
                case 1: {
                    phi = -phi;
                    coslam = -coslam;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = 1.5707963267948966 + phi;
                    xy.x = xy.y * Math.sin(lam);
                    xy.y *= coslam;
                }
            }
        } else {
            double coslam = Math.cos(lam);
            double cosphi = Math.cos(phi);
            double sinphi = Math.sin(phi);
            switch (this.mode) {
                case 1: {
                    coslam = -coslam;
                }
                case 2: {
                    double rho = Math.abs(this.Mp - ProjectionMath.mlfn(phi, sinphi, cosphi, this.en));
                    xy.x = rho * Math.sin(lam);
                    xy.y = rho * coslam;
                    break;
                }
                case 3: 
                case 4: {
                    if (Math.abs(lam) < 1.0E-10 && Math.abs(phi - this.projectionLatitude) < 1.0E-10) {
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    double t = Math.atan2(this.one_es * sinphi + this.es * this.N1 * this.sinphi0 * Math.sqrt(1.0 - this.es * sinphi * sinphi), cosphi);
                    double ct = Math.cos(t);
                    double st = Math.sin(t);
                    double Az = Math.atan2(Math.sin(lam) * ct, this.cosphi0 * st - this.sinphi0 * coslam * ct);
                    double cA = Math.cos(Az);
                    double sA = Math.sin(Az);
                    double s = ProjectionMath.asin(Math.abs(sA) < 1.0E-8 ? (this.cosphi0 * st - this.sinphi0 * coslam * ct) / cA : Math.sin(lam) * ct / sA);
                    double H = this.He * cA;
                    double H2 = H * H;
                    double c = this.N1 * s * (1.0 + s * s * (-H2 * (1.0 - H2) / 6.0 + s * (this.G * H * (1.0 - 2.0 * H2 * H2) / 8.0 + s * ((H2 * (4.0 - 7.0 * H2) - 3.0 * this.G * this.G * (1.0 - 7.0 * H2)) / 120.0 - s * this.G * H / 48.0))));
                    xy.x = c * sA;
                    xy.y = c * cA;
                }
            }
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        if (this.spherical) {
            double d;
            double c_rh = ProjectionMath.distance(x, y);
            if (d > Math.PI) {
                if (c_rh - 1.0E-10 > Math.PI) {
                    throw new ProjectionException();
                }
                c_rh = Math.PI;
            } else if (c_rh < 1.0E-10) {
                lp.y = this.projectionLatitude;
                lp.x = 0.0;
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double sinc = Math.sin(c_rh);
                double cosc = Math.cos(c_rh);
                if (this.mode == 3) {
                    lp.y = ProjectionMath.asin(y * sinc / c_rh);
                    x *= sinc;
                    y = cosc * c_rh;
                } else {
                    lp.y = ProjectionMath.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / c_rh);
                    y = (cosc - this.sinphi0 * Math.sin(lp.y)) * c_rh;
                    x *= sinc * this.cosphi0;
                }
                lp.x = y == 0.0 ? 0.0 : Math.atan2(x, y);
            } else if (this.mode == 1) {
                lp.y = 1.5707963267948966 - c_rh;
                lp.x = Math.atan2(x, -y);
            } else {
                lp.y = c_rh - 1.5707963267948966;
                lp.x = Math.atan2(x, y);
            }
        } else {
            double d;
            double c = ProjectionMath.distance(x, y);
            if (d < 1.0E-10) {
                lp.y = this.projectionLatitude;
                lp.x = 0.0;
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double d2;
                double Az = Math.atan2(x, y);
                double cosAz = Math.cos(Az);
                double t = this.cosphi0 * cosAz;
                double B = this.es * t / this.one_es;
                double A = -B * t;
                double D = c / this.N1;
                double E = D * (1.0 - D * D * (A * (1.0 + A) / 6.0 + (B *= 3.0 * (1.0 - A) * this.sinphi0) * (1.0 + 3.0 * A) * D / 24.0));
                double F = 1.0 - E * E * (A / 2.0 + B * E / 6.0);
                double psi = ProjectionMath.asin(this.sinphi0 * Math.cos(E) + t * Math.sin(E));
                lp.x = ProjectionMath.asin(Math.sin(Az) * Math.sin(E) / Math.cos(psi));
                t = Math.abs(psi);
                lp.y = d2 < 1.0E-10 ? 0.0 : (Math.abs(t - 1.5707963267948966) < 0.0 ? 1.5707963267948966 : Math.atan((1.0 - this.es * F * this.sinphi0 / Math.sin(psi)) * Math.tan(psi) / this.one_es));
            } else {
                lp.y = ProjectionMath.inv_mlfn(this.mode == 1 ? this.Mp - c : this.Mp + c, this.es, this.en);
                lp.x = Math.atan2(x, this.mode == 1 ? -y : y);
            }
        }
        return lp;
    }

    public Shape getBoundingShape() {
        double r = 1.5707963267948966 * this.a;
        return new Ellipse2D.Double(-r, -r, 2.0 * r, 2.0 * r);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Equidistant Azimuthal";
    }
}

