/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.constants.AllTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoAscii;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDouble;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoGpsText;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSByte;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSRational;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoSShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoXpString;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;

public class TiffImageMetadata
extends ImageMetadata {
    public final TiffContents contents;
    private static final Map<Object, Integer> TAG_COUNTS = TiffImageMetadata.countTags(AllTagConstants.ALL_TAGS);

    public TiffImageMetadata(TiffContents contents) {
        this.contents = contents;
    }

    private static Map<Object, Integer> countTags(List<TagInfo> tags) {
        Hashtable<Object, Integer> map = new Hashtable<Object, Integer>();
        for (TagInfo tag : tags) {
            Integer count = (Integer)map.get(tag.tag);
            if (count == null) {
                map.put(tag.tag, 1);
                continue;
            }
            map.put(tag.tag, count + 1);
        }
        return map;
    }

    public List<? extends IImageMetadata.IImageMetadataItem> getDirectories() {
        return super.getItems();
    }

    @Override
    public List<? extends IImageMetadata.IImageMetadataItem> getItems() {
        ArrayList<? extends IImageMetadata.IImageMetadataItem> result = new ArrayList<IImageMetadata.IImageMetadataItem>();
        List<? extends IImageMetadata.IImageMetadataItem> items = super.getItems();
        for (IImageMetadata.IImageMetadataItem iImageMetadataItem : items) {
            Directory dir = (Directory)iImageMetadataItem;
            result.addAll(dir.getItems());
        }
        return result;
    }

    public TiffOutputSet getOutputSet() throws ImageWriteException {
        ByteOrder byteOrder = this.contents.header.byteOrder;
        TiffOutputSet result = new TiffOutputSet(byteOrder);
        List<? extends IImageMetadata.IImageMetadataItem> srcDirs = this.getDirectories();
        for (IImageMetadata.IImageMetadataItem iImageMetadataItem : srcDirs) {
            Directory srcDir = (Directory)iImageMetadataItem;
            if (null != result.findDirectory(srcDir.type)) continue;
            TiffOutputDirectory outputDirectory = srcDir.getOutputDirectory(byteOrder);
            result.addDirectory(outputDirectory);
        }
        return result;
    }

    public TiffField findField(TagInfo tagInfo) throws ImageReadException {
        return this.findField(tagInfo, false);
    }

    public TiffField findField(TagInfo tagInfo, boolean exactDirectoryMatch) throws ImageReadException {
        TiffField field;
        Directory directory;
        Integer tagCount = TAG_COUNTS.get(tagInfo.tag);
        int tagsMatching = tagCount == null ? 0 : tagCount;
        List<? extends IImageMetadata.IImageMetadataItem> directories = this.getDirectories();
        if (exactDirectoryMatch || tagInfo.directoryType != TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN) {
            for (IImageMetadata.IImageMetadataItem iImageMetadataItem : directories) {
                directory = (Directory)iImageMetadataItem;
                if (directory.type != tagInfo.directoryType.directoryType || (field = directory.findField(tagInfo)) == null) continue;
                return field;
            }
            if (exactDirectoryMatch || tagsMatching > 1) {
                return null;
            }
            for (IImageMetadata.IImageMetadataItem iImageMetadataItem : directories) {
                directory = (Directory)iImageMetadataItem;
                if (!(tagInfo.directoryType.isImageDirectory() && directory.type >= 0 ? (field = directory.findField(tagInfo)) != null : !tagInfo.directoryType.isImageDirectory() && directory.type < 0 && (field = directory.findField(tagInfo)) != null)) continue;
                return field;
            }
        }
        for (IImageMetadata.IImageMetadataItem iImageMetadataItem : directories) {
            directory = (Directory)iImageMetadataItem;
            field = directory.findField(tagInfo);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public Object getFieldValue(TagInfo tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public byte[] getFieldValue(TagInfoByte tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        return field.getByteArrayValue();
    }

    public String[] getFieldValue(TagInfoAscii tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public short[] getFieldValue(TagInfoShort tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int[] getFieldValue(TagInfoLong tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber[] getFieldValue(TagInfoRational tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public byte[] getFieldValue(TagInfoSByte tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        return field.getByteArrayValue();
    }

    public short[] getFieldValue(TagInfoSShort tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public int[] getFieldValue(TagInfoSLong tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public RationalNumber[] getFieldValue(TagInfoSRational tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public float[] getFieldValue(TagInfoFloat tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public double[] getFieldValue(TagInfoDouble tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        byte[] bytes = field.getByteArrayValue();
        return tag.getValue(field.getByteOrder(), bytes);
    }

    public String getFieldValue(TagInfoGpsText tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        return tag.getValue(field);
    }

    public String getFieldValue(TagInfoXpString tag) throws ImageReadException {
        TiffField field = this.findField(tag);
        if (field == null) {
            return null;
        }
        return tag.getValue(field);
    }

    public TiffDirectory findDirectory(int directoryType) {
        List<? extends IImageMetadata.IImageMetadataItem> directories = this.getDirectories();
        for (IImageMetadata.IImageMetadataItem iImageMetadataItem : directories) {
            Directory directory = (Directory)iImageMetadataItem;
            if (directory.type != directoryType) continue;
            return directory.directory;
        }
        return null;
    }

    public List<TiffField> getAllFields() {
        ArrayList<TiffField> result = new ArrayList<TiffField>();
        List<? extends IImageMetadata.IImageMetadataItem> directories = this.getDirectories();
        for (IImageMetadata.IImageMetadataItem iImageMetadataItem : directories) {
            Directory directory = (Directory)iImageMetadataItem;
            result.addAll(directory.getAllFields());
        }
        return result;
    }

    public GPSInfo getGPS() throws ImageReadException {
        TiffDirectory gpsDirectory = this.findDirectory(-3);
        if (null == gpsDirectory) {
            return null;
        }
        TiffField latitudeRefField = gpsDirectory.findField(GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
        TiffField latitudeField = gpsDirectory.findField(GpsTagConstants.GPS_TAG_GPS_LATITUDE);
        TiffField longitudeRefField = gpsDirectory.findField(GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
        TiffField longitudeField = gpsDirectory.findField(GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
        if (latitudeRefField == null || latitudeField == null || longitudeRefField == null || longitudeField == null) {
            return null;
        }
        String latitudeRef = latitudeRefField.getStringValue();
        RationalNumber[] latitude = (RationalNumber[])latitudeField.getValue();
        String longitudeRef = longitudeRefField.getStringValue();
        RationalNumber[] longitude = (RationalNumber[])longitudeField.getValue();
        if (latitude.length != 3 || longitude.length != 3) {
            throw new ImageReadException("Expected three values for latitude and longitude.");
        }
        RationalNumber latitudeDegrees = latitude[0];
        RationalNumber latitudeMinutes = latitude[1];
        RationalNumber latitudeSeconds = latitude[2];
        RationalNumber longitudeDegrees = longitude[0];
        RationalNumber longitudeMinutes = longitude[1];
        RationalNumber longitudeSeconds = longitude[2];
        return new GPSInfo(latitudeRef, longitudeRef, latitudeDegrees, latitudeMinutes, latitudeSeconds, longitudeDegrees, longitudeMinutes, longitudeSeconds);
    }

    public static class GPSInfo {
        public final String latitudeRef;
        public final String longitudeRef;
        public final RationalNumber latitudeDegrees;
        public final RationalNumber latitudeMinutes;
        public final RationalNumber latitudeSeconds;
        public final RationalNumber longitudeDegrees;
        public final RationalNumber longitudeMinutes;
        public final RationalNumber longitudeSeconds;

        public GPSInfo(String latitudeRef, String longitudeRef, RationalNumber latitudeDegrees, RationalNumber latitudeMinutes, RationalNumber latitudeSeconds, RationalNumber longitudeDegrees, RationalNumber longitudeMinutes, RationalNumber longitudeSeconds) {
            this.latitudeRef = latitudeRef;
            this.longitudeRef = longitudeRef;
            this.latitudeDegrees = latitudeDegrees;
            this.latitudeMinutes = latitudeMinutes;
            this.latitudeSeconds = latitudeSeconds;
            this.longitudeDegrees = longitudeDegrees;
            this.longitudeMinutes = longitudeMinutes;
            this.longitudeSeconds = longitudeSeconds;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(88);
            result.append("[GPS. Latitude: " + this.latitudeDegrees.toDisplayString() + " degrees, " + this.latitudeMinutes.toDisplayString() + " minutes, " + this.latitudeSeconds.toDisplayString() + " seconds " + this.latitudeRef);
            result.append(", Longitude: " + this.longitudeDegrees.toDisplayString() + " degrees, " + this.longitudeMinutes.toDisplayString() + " minutes, " + this.longitudeSeconds.toDisplayString() + " seconds " + this.longitudeRef);
            result.append(']');
            return result.toString();
        }

        public double getLongitudeAsDegreesEast() throws ImageReadException {
            double result = this.longitudeDegrees.doubleValue() + this.longitudeMinutes.doubleValue() / 60.0 + this.longitudeSeconds.doubleValue() / 3600.0;
            if (this.longitudeRef.trim().equalsIgnoreCase("e")) {
                return result;
            }
            if (this.longitudeRef.trim().equalsIgnoreCase("w")) {
                return -result;
            }
            throw new ImageReadException("Unknown longitude ref: \"" + this.longitudeRef + "\"");
        }

        public double getLatitudeAsDegreesNorth() throws ImageReadException {
            double result = this.latitudeDegrees.doubleValue() + this.latitudeMinutes.doubleValue() / 60.0 + this.latitudeSeconds.doubleValue() / 3600.0;
            if (this.latitudeRef.trim().equalsIgnoreCase("n")) {
                return result;
            }
            if (this.latitudeRef.trim().equalsIgnoreCase("s")) {
                return -result;
            }
            throw new ImageReadException("Unknown latitude ref: \"" + this.latitudeRef + "\"");
        }
    }

    public static class Item
    extends ImageMetadata.Item {
        private final TiffField entry;

        public Item(TiffField entry) {
            super(entry.getTagName(), entry.getValueDescription());
            this.entry = entry;
        }

        public TiffField getTiffField() {
            return this.entry;
        }
    }

    public static class Directory
    extends ImageMetadata
    implements IImageMetadata.IImageMetadataItem {
        public final int type;
        private final TiffDirectory directory;
        private final ByteOrder byteOrder;

        public Directory(ByteOrder byteOrder, TiffDirectory directory) {
            this.type = directory.type;
            this.directory = directory;
            this.byteOrder = byteOrder;
        }

        public void add(TiffField entry) {
            this.add(new Item(entry));
        }

        public BufferedImage getThumbnail() throws ImageReadException, IOException {
            return this.directory.getTiffImage(this.byteOrder);
        }

        public TiffImageData getTiffImageData() {
            return this.directory.getTiffImageData();
        }

        public TiffField findField(TagInfo tagInfo) throws ImageReadException {
            return this.directory.findField(tagInfo);
        }

        public List<TiffField> getAllFields() {
            return this.directory.getDirectoryEntries();
        }

        public JpegImageData getJpegImageData() {
            return this.directory.getJpegImageData();
        }

        @Override
        public String toString(String prefix) {
            return (prefix != null ? prefix : "") + this.directory.description() + ": " + (this.getTiffImageData() != null ? " (tiffImageData)" : "") + (this.getJpegImageData() != null ? " (jpegImageData)" : "") + "\n" + super.toString(prefix) + "\n";
        }

        public TiffOutputDirectory getOutputDirectory(ByteOrder byteOrder) throws ImageWriteException {
            try {
                TiffOutputDirectory dstDir = new TiffOutputDirectory(this.type, byteOrder);
                List<? extends IImageMetadata.IImageMetadataItem> entries = this.getItems();
                for (IImageMetadata.IImageMetadataItem iImageMetadataItem : entries) {
                    Item item = (Item)iImageMetadataItem;
                    TiffField srcField = item.getTiffField();
                    if (null != dstDir.findField(srcField.getTag()) || srcField.getTagInfo().isOffset()) continue;
                    TagInfo tagInfo = srcField.getTagInfo();
                    FieldType fieldType = srcField.getFieldType();
                    Object value = srcField.getValue();
                    byte[] bytes = tagInfo.encodeValue(fieldType, value, byteOrder);
                    int count = bytes.length / fieldType.getSize();
                    TiffOutputField dstField = new TiffOutputField(srcField.getTag(), tagInfo, fieldType, count, bytes);
                    dstField.setSortHint(srcField.getSortHint());
                    dstDir.add(dstField);
                }
                dstDir.setTiffImageData(this.getTiffImageData());
                dstDir.setJpegImageData(this.getJpegImageData());
                return dstDir;
            }
            catch (ImageReadException e) {
                throw new ImageWriteException(e.getMessage(), e);
            }
        }
    }
}

