/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.geometry.BoundingBox;

class WFSFeatureCollection
extends DataFeatureCollection {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private Query query;
    private WFS_1_1_0_DataStore dataStore;
    private SimpleFeatureType contentType;
    private int cachedSize = -1;
    private ReferencedEnvelope cachedBounds = null;

    public WFSFeatureCollection(WFS_1_1_0_DataStore dataStore, Query query) throws IOException {
        this.dataStore = dataStore;
        this.query = query;
        this.contentType = dataStore.getQueryType(query);
    }

    public SimpleFeatureType getSchema() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds;
        block8: {
            if (this.cachedBounds != null) {
                return this.cachedBounds;
            }
            bounds = null;
            try {
                bounds = this.dataStore.getBounds(this.query);
                if (bounds != null) break block8;
                Name defaultgeom = this.contentType.getGeometryDescriptor().getName();
                Query geomQuery = new Query(this.query);
                geomQuery.setPropertyNames(new String[]{defaultgeom.getLocalPart()});
                bounds = new ReferencedEnvelope(this.contentType.getCoordinateReferenceSystem());
                try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.dataStore.getFeatureReader(geomQuery, Transaction.AUTO_COMMIT);){
                    int collectionSize = 0;
                    while (reader.hasNext()) {
                        BoundingBox featureBounds = ((SimpleFeature)reader.next()).getBounds();
                        bounds.expandToInclude(featureBounds.getMinX(), featureBounds.getMinY());
                        bounds.expandToInclude(featureBounds.getMaxX(), featureBounds.getMaxY());
                        ++collectionSize;
                    }
                    if (this.cachedSize == -1) {
                        this.cachedSize = collectionSize;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Error getting bounds for " + this.query);
                bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            }
        }
        return bounds;
    }

    public int getCount() throws IOException {
        if (this.cachedSize != -1) {
            return this.cachedSize;
        }
        this.cachedSize = this.dataStore.getCount(this.query);
        if (this.cachedSize == -1) {
            this.getBounds();
        }
        return this.cachedSize;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.dataStore.getFeatureReader(this.query, Transaction.AUTO_COMMIT);
        return reader;
    }
}

