/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.http;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.geotools.util.logging.Logging;

public class HttpUtil {
    protected static final Logger LOGGER = Logging.getLogger(HttpUtil.class);

    public static URL createUrl(URL baseUrl, Map<String, String> queryStringKvp) throws MalformedURLException {
        String finalUrlString = HttpUtil.createUri(baseUrl, queryStringKvp);
        URL queryUrl = new URL(finalUrlString);
        return queryUrl;
    }

    public static String createUri(URL baseUrl, Map<String, String> queryStringKvp) {
        String query = baseUrl.getQuery();
        HashMap<String, String> finalKvpMap = new HashMap<String, String>(queryStringKvp);
        if (query != null && query.length() > 0) {
            String[] rawUrlKvpSet;
            CaseInsensitiveMap userParams = new CaseInsensitiveMap(queryStringKvp);
            if (query.endsWith("&amp;")) {
                query = query.substring(0, query.length() - 5);
            }
            for (String rawUrlKvp : rawUrlKvpSet = query.split("&")) {
                String value;
                String key;
                int eqIdx = rawUrlKvp.indexOf(61);
                if (eqIdx > 0) {
                    key = rawUrlKvp.substring(0, eqIdx);
                    value = rawUrlKvp.substring(eqIdx + 1);
                } else {
                    key = rawUrlKvp;
                    value = null;
                }
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (userParams.containsKey(key)) {
                    LOGGER.fine("user supplied value for query string argument " + key + " overrides the one in the base url");
                    continue;
                }
                finalKvpMap.put(key, value);
            }
        }
        String protocol = baseUrl.getProtocol();
        String host = baseUrl.getHost();
        int port = baseUrl.getPort();
        String path = baseUrl.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append(protocol).append("://").append(host);
        if (port != -1 && port != baseUrl.getDefaultPort()) {
            sb.append(':');
            sb.append(port);
        }
        if (!"".equals(path) && !path.startsWith("/")) {
            sb.append('/');
        }
        sb.append(path).append('?');
        try {
            Iterator it = finalKvpMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry kvp = it.next();
                String key = (String)kvp.getKey();
                String value = (String)kvp.getValue();
                value = value == null ? "" : URLEncoder.encode(value, "UTF-8");
                sb.append(key);
                sb.append('=');
                sb.append(value);
                if (!it.hasNext()) continue;
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String finalUrlString = sb.toString();
        return finalUrlString;
    }

    public static Map<String, String> requestKvp(URL url) {
        String queryString = url.getQuery();
        String[] split = queryString.split("&");
        LinkedHashMap<String, String> kvp = new LinkedHashMap<String, String>();
        for (String encodedKvp : split) {
            String value;
            String[] splittedKvp = encodedKvp.split("=");
            String key = splittedKvp[0];
            String string = value = splittedKvp.length == 2 ? splittedKvp[1] : null;
            if (value != null) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            kvp.put(key, value);
        }
        return new CaseInsensitiveMap(kvp);
    }
}

