/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.feature;

import org.geotools.feature.AttributeImpl;
import org.geotools.feature.PropertyImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.feature.Attribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.identity.Identifier;

public class LenientAttribute
extends PropertyImpl
implements Attribute {
    protected final Identifier id;

    public LenientAttribute(Object content, AttributeDescriptor descriptor, String id) {
        super(content, (PropertyDescriptor)descriptor);
        this.id = id != null ? new GmlObjectIdImpl(id) : null;
    }

    public LenientAttribute(Object content, AttributeType type, String id) {
        this(content, (AttributeDescriptor)new AttributeDescriptorImpl(type, type.getName(), 1, 1, true, null), id);
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public AttributeDescriptor getDescriptor() {
        return (AttributeDescriptor)super.getDescriptor();
    }

    public AttributeType getType() {
        return (AttributeType)super.getType();
    }

    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        super.setValue(newValue);
    }

    public int hashCode() {
        return super.hashCode() + 37 * (this.id == null ? 0 : this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AttributeImpl att = (AttributeImpl)obj;
        return Utilities.equals((Object)this.id, (Object)att.getIdentifier());
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        return super.toString() + ":" + this.id;
    }

    protected Object parse(Object value) throws IllegalArgumentException {
        Object converted;
        Class target;
        if (value != null && !(target = this.getType().getBinding()).isAssignableFrom(value.getClass()) && (converted = Converters.convert((Object)value, (Class)target)) != null) {
            value = converted;
        }
        return value;
    }

    public void validate() throws IllegalAttributeException {
    }
}

