/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.markwkt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.shape.ExplicitBoundsShape;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class MeteoMarkFactory
implements MarkFactory {
    public static final String SHAPE_PREFIX = "extshape://";
    private static final Logger LOGGER = Logging.getLogger(MeteoMarkFactory.class);
    protected static final Map<String, Shape> WELLKNOWN_SHAPES = new HashMap<String, Shape>();

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        String wellKnownName;
        if (symbolUrl == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to resolve symbol:" + symbolUrl.toString());
        }
        if ((wellKnownName = (String)symbolUrl.evaluate((Object)feature, String.class)) == null || !wellKnownName.startsWith(SHAPE_PREFIX)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to resolve symbol");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Resolved symbol");
        }
        return WELLKNOWN_SHAPES.get(wellKnownName.substring(SHAPE_PREFIX.length()));
    }

    static {
        GeneralPath gp = new GeneralPath();
        gp = new GeneralPath();
        ExplicitBoundsShape bnd = null;
        gp.moveTo(-0.145f, 0.0f);
        gp.lineTo(0.0f, 0.175f);
        gp.lineTo(0.105f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 0.5, 0.5));
        WELLKNOWN_SHAPES.put("triangle", bnd);
        gp = new GeneralPath();
        gp.moveTo(-0.125f, 0.0f);
        gp.curveTo(-0.125f, 0.0f, 0.0f, 0.25f, 0.125f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 0.5, 0.5));
        WELLKNOWN_SHAPES.put("emicircle", bnd);
        gp = new GeneralPath();
        gp.moveTo(-0.395f, 0.0f);
        gp.lineTo(-0.25f, -0.175f);
        gp.lineTo(-0.145f, 0.0f);
        gp.moveTo(0.125f, 0.0f);
        gp.curveTo(0.125f, 0.0f, 0.25f, 0.25f, 0.375f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        WELLKNOWN_SHAPES.put("triangleemicircle", bnd);
        gp = new GeneralPath();
        gp.moveTo(0.0f, 0.5f);
        gp.lineTo(0.5, -0.5);
        gp.lineTo(0.1f, -0.5f);
        gp.lineTo(0.1f, -2.0f);
        gp.lineTo(-0.1f, -2.0f);
        gp.lineTo(-0.1f, -0.5f);
        gp.lineTo(-0.5f, -0.5f);
        gp.closePath();
        ExplicitBoundsShape narrow = new ExplicitBoundsShape(gp);
        narrow.setBounds(new Rectangle2D.Double(-1.2, -0.3, 1.0, 0.6));
        WELLKNOWN_SHAPES.put("narrow", narrow);
        AffineTransform at = AffineTransform.getQuadrantRotateInstance(2);
        gp = new GeneralPath();
        gp.moveTo(0.0f, 0.5f);
        gp.lineTo(0.5, -0.5);
        gp.lineTo(0.1f, -0.5f);
        gp.lineTo(0.1f, -2.0f);
        gp.lineTo(-0.1f, -2.0f);
        gp.lineTo(-0.1f, -0.5f);
        gp.lineTo(-0.5f, -0.5f);
        gp.closePath();
        gp.transform(at);
        ExplicitBoundsShape sarrow = new ExplicitBoundsShape(gp);
        WELLKNOWN_SHAPES.put("sarrow", sarrow);
    }
}

