/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.vividsolutions.jts.algorithm.match.HausdorffSimilarityMeasure;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.PolygonExtractor;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class GridCoverageRenderer {
    private static final double EPS = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger(GridCoverageRenderer.class);
    private static final AffineTransform IDENTITY = AffineTransform2D.getTranslateInstance((double)0.0, (double)0.0);
    private static boolean DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
    private static String DUMP_DIRECTORY;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private Hints hints = new Hints();
    private Interpolation interpolation = new InterpolationNearest();
    private final GridCoverageFactory gridCoverageFactory;
    private boolean wrapEnabled = true;
    private boolean advancedProjectionHandlingEnabled = true;

    public void setWrapEnabled(boolean wrapEnabled) {
        this.wrapEnabled = wrapEnabled;
    }

    public boolean isWrapEnabled() {
        return this.wrapEnabled;
    }

    public void setAdvancedProjectionHandlingEnabled(boolean enabled) {
        this.advancedProjectionHandlingEnabled = enabled;
    }

    public boolean isAdvancedProjectionHandlingEnabled() {
        return this.advancedProjectionHandlingEnabled;
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, worldToScreen, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen, RenderingHints newHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = destinationCRS;
        if (this.destinationCRS == null) {
            throw new TransformException(Errors.format((int)31, (Object)this.destinationCRS));
        }
        this.destinationEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(envelope, this.destinationCRS));
        if (worldToScreen != null && XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            this.finalWorldToGrid = new AffineTransform(worldToScreen);
            this.finalGridToWorld = this.finalWorldToGrid.createInverse();
        } else {
            GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper();
            gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            gridToEnvelopeMapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.destinationSize));
            gridToEnvelopeMapper.setEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
            this.finalGridToWorld = new AffineTransform(gridToEnvelopeMapper.createAffineTransform());
            this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        }
        if (newHints != null) {
            this.hints.add(newHints);
        }
        this.gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)JAI.KEY_INTERPOLATION)) {
            this.interpolation = (Interpolation)newHints.get(JAI.KEY_INTERPOLATION);
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering using interpolation " + this.interpolation);
        }
        this.setInterpolationHints();
        if (this.hints.containsKey((Object)JAI.KEY_IMAGE_LAYOUT)) {
            ImageLayout layout = (ImageLayout)this.hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
            layout.unsetImageBounds();
            layout.unsetValid(0);
        }
        this.hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        this.hints.put((Object)Hints.COVERAGE_PROCESSING_VIEW, (Object)ViewType.SAME);
        this.hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
    }

    private void setInterpolationHints() {
        if (this.interpolation instanceof InterpolationNearest) {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.TRUE));
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE));
        }
    }

    static void writeRenderedImage(RenderedImage raster, String fileName) {
        if (DUMP_DIRECTORY == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(DUMP_DIRECTORY, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        GridCoverage2D symbolizerGC = this.renderCoverage(gridCoverage, symbolizer, bkgValues);
        return symbolizerGC.getRenderedImage();
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws FactoryException {
        GridCoverage2D symbolizerGC;
        GridCoverage2D preReprojection;
        GridCoverageRendererUtilities.ensureNotNull(gridCoverage, "gridCoverage");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        boolean doReprojection = false;
        CoordinateReferenceSystem coverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
        if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.destinationCRS)) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coverageCRS, (CoordinateReferenceSystem)this.destinationCRS, (boolean)true);
            boolean bl = doReprojection = !transform.isIdentity();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reproject needed for rendering provided coverage");
            }
        }
        if ((preReprojection = this.crop(gridCoverage, this.destinationEnvelope, doReprojection)) == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Skipping current coverage because crop failed");
            }
            return null;
        }
        GridCoverage2D afterReprojection = this.reproject(preReprojection, doReprojection, bkgValues);
        GridCoverage2D preSymbolizer = this.affine(afterReprojection, bkgValues);
        if (preSymbolizer == null) {
            return null;
        }
        if (symbolizer != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Applying Raster Symbolizer ");
            }
            RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(preSymbolizer, this.hints);
            rsp.visit(symbolizer);
            symbolizerGC = (GridCoverage2D)rsp.getOutput();
        } else {
            symbolizerGC = preSymbolizer;
        }
        if (DEBUG) {
            GridCoverageRenderer.writeRenderedImage(symbolizerGC.geophysics(false).getRenderedImage(), "postSymbolizer");
        }
        return symbolizerGC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D reproject(GridCoverage2D preResample, boolean doReprojection, double[] bkgValues) throws FactoryException {
        GridCoverage2D afterReprojection = null;
        try {
            if (doReprojection) {
                afterReprojection = GridCoverageRendererUtilities.reproject(preResample, this.destinationCRS, this.interpolation, this.destinationEnvelope, bkgValues, this.hints);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toString());
                }
            } else {
                afterReprojection = preResample;
            }
            GridCoverage2D gridCoverage2D = afterReprojection;
            return gridCoverage2D;
        }
        finally {
            if (DEBUG && afterReprojection != null) {
                GridCoverageRenderer.writeRenderedImage(afterReprojection.geophysics(false).getRenderedImage(), "afterReprojection");
            }
        }
    }

    private GridCoverage2D crop(GridCoverage2D inputCoverage, GeneralEnvelope destinationEnvelope, boolean doReprojection) {
        GridCoverage2D outputCoverage = inputCoverage;
        GeneralEnvelope coverageEnvelope = (GeneralEnvelope)inputCoverage.getEnvelope();
        CoordinateReferenceSystem coverageCRS = inputCoverage.getCoordinateReferenceSystem2D();
        try {
            GeneralEnvelope renderingEnvelopeInCoverageCRS = null;
            renderingEnvelopeInCoverageCRS = doReprojection ? GridCoverageRendererUtilities.reprojectEnvelopeWithWGS84Pivot(destinationEnvelope, coverageCRS) : new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelope);
            GeneralEnvelope cropEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)renderingEnvelopeInCoverageCRS);
            cropEnvelope.intersect((org.opengis.geometry.Envelope)coverageEnvelope);
            if (cropEnvelope.isEmpty() || cropEnvelope.isNull()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("The destination envelope does not intersect the envelope of the source coverage.");
                }
                return null;
            }
            outputCoverage = GridCoverageRendererUtilities.crop(inputCoverage, cropEnvelope, this.hints);
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Crop Failed for reason: " + t.getLocalizedMessage(), t);
            }
            outputCoverage = inputCoverage;
        }
        if (DEBUG) {
            GridCoverageRenderer.writeRenderedImage(outputCoverage.geophysics(false).getRenderedImage(), "crop");
        }
        return outputCoverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GridCoverage2D affine(GridCoverage2D input, double[] bkgValues) {
        RenderedImage im;
        block8: {
            RenderedImage finalImage = input.getRenderedImage();
            GridGeometry2D preSymbolizerGridGeometry = input.getGridGeometry();
            MathTransform2D finalGCTransform = preSymbolizerGridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            if (!(finalGCTransform instanceof AffineTransform)) {
                throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
            }
            AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)finalGCTransform);
            AffineTransform finalRasterTransformation = (AffineTransform)this.finalWorldToGrid.clone();
            finalRasterTransformation.concatenate(finalGCgridToWorld);
            Rectangle2D finalLayout = GridCoverageRendererUtilities.layoutHelper(finalImage, (float)finalRasterTransformation.getScaleX(), (float)finalRasterTransformation.getScaleY(), (float)finalRasterTransformation.getTranslateX(), (float)finalRasterTransformation.getTranslateY(), this.interpolation);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug");
                }
                return null;
            }
            im = null;
            try {
                ImageWorker iw = new ImageWorker(finalImage);
                iw.setRenderingHints((RenderingHints)this.hints);
                iw.affine(finalRasterTransformation, this.interpolation, bkgValues);
                im = iw.getRenderedImage();
                if (!DEBUG) break block8;
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    GridCoverageRenderer.writeRenderedImage(im, "postAffine");
                }
                throw throwable;
            }
            GridCoverageRenderer.writeRenderedImage(im, "postAffine");
        }
        int numBands = im.getSampleModel().getNumBands();
        GridSampleDimension[] sd = new GridSampleDimension[numBands];
        int i = 0;
        while (i < numBands) {
            sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)im.getColorModel(), (int)i).name());
            ++i;
        }
        return this.gridCoverageFactory.create((CharSequence)input.getName(), im, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)im).getBounds()), input.getEnvelope()), sd, new GridCoverage[]{input}, input.getProperties());
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException {
        GridCoverage2D coverage = this.renderCoverage(gridCoverage, symbolizer, interpolation, background, tileSizeX, tileSizeY);
        return coverage.getRenderedImage();
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException {
        Hints oldHints = this.hints.clone();
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        try {
            GridCoverage2D gridCoverage2D = this.renderCoverage(gridCoverage, symbolizer, GridCoverageRendererUtilities.colorToArray(background));
            return gridCoverage2D;
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
        finally {
            this.hints = oldHints;
        }
    }

    private void setupTilingHints(int tileSizeX, int tileSizeY) {
        if (tileSizeX > 0 && tileSizeY > 0) {
            ImageLayout2 layout = new ImageLayout2();
            layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(tileSizeY).setTileWidth(tileSizeX);
            this.hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
    }

    private void setupInterpolationHints(Interpolation interpolation) {
        if (interpolation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.interpolation = interpolation;
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.setInterpolationHints();
        }
    }

    public RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException, IOException {
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        return this.renderImage(reader, readParams, symbolizer, interpolation, background);
    }

    /*
     * WARNING - void declaration
     */
    private RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws FactoryException, IOException, TransformException {
        void var14_20;
        List<Object> coverages;
        CoordinateReferenceSystem sourceCRS = reader.getCoordinateReferenceSystem();
        CoordinateReferenceSystem targetCRS = this.destinationEnvelope.getCoordinateReferenceSystem();
        ProjectionHandler handler = null;
        GridCoverageReaderHelper rh = new GridCoverageReaderHelper(reader, this.destinationSize, ReferencedEnvelope.reference((org.opengis.geometry.Envelope)this.destinationEnvelope), interpolation);
        if (GridCoverageReaderHelper.isReprojectingReader(reader)) {
            GridCoverage2D coverage = rh.readCoverage(readParams);
            coverages = new ArrayList<GridCoverage2D>();
            coverages.add(coverage);
        } else {
            handler = ProjectionHandlerFinder.getHandler(rh.getReadEnvelope(), sourceCRS, this.wrapEnabled);
            if (handler instanceof WrappingProjectionHandler) {
                ((WrappingProjectionHandler)handler).setDatelineWrappingCheckEnabled(false);
            }
            coverages = rh.readCoverages(readParams, handler);
        }
        double[] bgValues = GridCoverageRendererUtilities.colorToArray(background);
        ArrayList<Object> reprojectedCoverages = new ArrayList<Object>();
        for (GridCoverage2D gridCoverage2D : coverages) {
            CoordinateReferenceSystem coverageCRS = gridCoverage2D.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.destinationCRS)) {
                GridCoverage2D reprojected = this.reproject(gridCoverage2D, true, bgValues);
                if (reprojected == null) continue;
                reprojectedCoverages.add(reprojected);
                continue;
            }
            reprojectedCoverages.addAll(coverages);
        }
        ArrayList<GridCoverage2D> displacedCoverages = new ArrayList<GridCoverage2D>();
        if (handler != null) {
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)this.destinationEnvelope);
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            PolygonExtractor polygonExtractor = new PolygonExtractor();
            for (GridCoverage2D gridCoverage2D : reprojectedCoverages) {
                Polygon polygon = JTS.toGeometry((BoundingBox)gridCoverage2D.getEnvelope2D());
                Geometry postProcessed = handler.postProcess(mt, (Geometry)polygon);
                List<Polygon> polygons = polygonExtractor.getPolygons(postProcessed);
                for (Polygon displaced : polygons) {
                    Envelope intersection = referencedEnvelope.intersection(displaced.getEnvelopeInternal());
                    if (intersection == null || intersection.isNull() || intersection.getArea() == 0.0) continue;
                    if (displaced.equals((Geometry)polygon)) {
                        displacedCoverages.add(gridCoverage2D);
                        continue;
                    }
                    double[] tx = this.getTranslationFactors(polygon, displaced);
                    if (tx == null) continue;
                    GridCoverage2D displacedCoverage = this.displaceCoverage(gridCoverage2D, tx[0], tx[1]);
                    displacedCoverages.add(displacedCoverage);
                }
            }
        } else {
            displacedCoverages.addAll(reprojectedCoverages);
        }
        Object var14_17 = null;
        if (displacedCoverages.size() == 0) {
            return null;
        }
        if (displacedCoverages.size() == 1) {
            GridCoverage2D gridCoverage2D = (GridCoverage2D)displacedCoverages.get(0);
        } else {
            GridCoverage2D gridCoverage2D = GridCoverageRendererUtilities.mosaic(displacedCoverages, this.destinationEnvelope, this.hints);
        }
        if (var14_20 == null) {
            return null;
        }
        GridCoverage2D result = this.renderCoverage((GridCoverage2D)var14_20, symbolizer, GridCoverageRendererUtilities.colorToArray(background));
        if (result == null) {
            return null;
        }
        return result.getRenderedImage();
    }

    private GridCoverage2D displaceCoverage(GridCoverage2D coverage, double tx, double ty) {
        GridGeometry2D originalGG = coverage.getGridGeometry();
        GridEnvelope gridRange = originalGG.getGridRange();
        Envelope2D envelope = originalGG.getEnvelope2D();
        double minx = envelope.getMinX() + tx;
        double miny = envelope.getMinY() + ty;
        double maxx = envelope.getMaxX() + tx;
        double maxy = envelope.getMaxY() + ty;
        ReferencedEnvelope translatedEnvelope = new ReferencedEnvelope(minx, maxx, miny, maxy, envelope.getCoordinateReferenceSystem());
        GridGeometry2D translatedGG = new GridGeometry2D(gridRange, (org.opengis.geometry.Envelope)translatedEnvelope);
        GridCoverage2D translatedCoverage = this.gridCoverageFactory.create((CharSequence)coverage.getName(), coverage.getRenderedImage(), translatedGG, coverage.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
        return translatedCoverage;
    }

    private double[] getTranslationFactors(Polygon reference, Polygon displaced) {
        Envelope re = reference.getEnvelopeInternal();
        Envelope de = displaced.getEnvelopeInternal();
        double dw = Math.abs(re.getWidth() - de.getWidth());
        double dh = Math.abs(re.getHeight() - de.getHeight());
        if (dw > 1.0E-6 * re.getWidth() || dh > 1.0E-6 * re.getWidth()) {
            return null;
        }
        double dx = de.getMinX() - re.getMinX();
        double dy = de.getMinY() - re.getMinY();
        Polygon cloned = (Polygon)displaced.clone();
        cloned.apply((CoordinateSequenceFilter)AffineTransformation.translationInstance((double)(-dx), (double)(-dy)));
        HausdorffSimilarityMeasure hausdorffSimilarityMeasure = new HausdorffSimilarityMeasure();
        if (1.0 - hausdorffSimilarityMeasure.measure((Geometry)cloned, (Geometry)reference) > 1.0E-6) {
            return null;
        }
        return new double[]{dx, dy};
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws Exception {
        this.paint(graphics, gridCoverage, symbolizer, null);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverage == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverage"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        RenderedImage finalImage = this.renderImage(gridCoverage, symbolizer, bkgValues);
        this.paintImage(graphics, finalImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics, GridCoverage2DReader gridCoverageReader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws Exception {
        RenderedImage finalImage;
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverageReader == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverageReader"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing reader " + gridCoverageReader.toString());
        }
        if ((finalImage = this.renderImage(gridCoverageReader, readParams, symbolizer, interpolation, background)) != null) {
            try {
                this.paintImage(graphics, finalImage);
            }
            finally {
                if (finalImage instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)finalImage));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImage(Graphics2D graphics, RenderedImage finalImage) {
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        try {
            if (DEBUG) {
                GridCoverageRenderer.writeRenderedImage(finalImage, "final");
            }
            graphics.setComposite(AlphaComposite.getInstance(3));
            graphics.drawRenderedImage(finalImage, IDENTITY);
        }
        catch (Throwable t) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
                if (t instanceof IllegalArgumentException) {
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(finalImage, "preWORKAROUND1");
                    }
                    RenderedImage image = new ImageWorker(finalImage).forceComponentColorModel(true).getRenderedImage();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(image, "WORKAROUND1");
                    }
                    graphics.drawRenderedImage(image, IDENTITY);
                } else if (t instanceof ImagingOpException) {
                    BufferedImage buf;
                    BufferedImage bufferedImage = buf = finalImage.getColorModel().hasAlpha() ? new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 6) : new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 5);
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "preWORKAROUND2");
                    }
                    Graphics2D g = (Graphics2D)buf.getGraphics();
                    int translationX = finalImage.getMinX();
                    int translationY = finalImage.getMinY();
                    g.drawRenderedImage(finalImage, AffineTransform.getTranslateInstance(-translationX, -translationY));
                    g.dispose();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "WORKAROUND2");
                    }
                    IDENTITY.concatenate(AffineTransform.getTranslateInstance(translationX, translationY));
                    graphics.drawImage(buf, IDENTITY, null);
                    buf.flush();
                    buf = null;
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to renderer this raster, no workaround found");
                }
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
            finally {
                graphics.setRenderingHints(oldHints);
            }
        }
    }

    static {
        if (DEBUG) {
            File tempDir = new File(System.getProperty("user.home"), "gt-renderer");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    System.out.println("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                DUMP_DIRECTORY = null;
            } else {
                DUMP_DIRECTORY = tempDir.getAbsolutePath();
                System.out.println("Rendering debug dir " + DUMP_DIRECTORY);
            }
        }
    }
}

