/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMap;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMapElement;
import org.geotools.renderer.lite.gridcoverage2d.RasterClassifier;
import org.geotools.renderer.lite.gridcoverage2d.SLDColorMapBuilder;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

class ColorMapNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final Logger LOGGER = Logging.getLogger((String)ColorMapNode.class.getName());
    private int type;
    private LinearColorMap colorMapTransform;
    private boolean extendedColors;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(5);
    }

    @Override
    public void visit(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.type = colorMap.getType();
        this.extendedColors = colorMap.getExtendedColors();
        ColorMapEntry[] cmEntries = colorMap.getColorMapEntries();
        if (cmEntries != null && cmEntries.length > 0) {
            CoverageProcessingNode source = this.getSource(0);
            GridCoverageRendererUtilities.ensureSourceNotNull(source, "ColorMapNode");
            GridCoverage2D sourceCoverage = (GridCoverage2D)source.getOutput();
            GridCoverageRendererUtilities.ensureSourceNotNull(sourceCoverage, "ColorMapNode");
            int numSD = sourceCoverage.getNumSampleDimensions();
            if (numSD > 1) {
                throw new IllegalArgumentException(Errors.format(7, numSD));
            }
            GridSampleDimension candidateSD = sourceCoverage.getSampleDimension(0);
            double[] candidateNoDataValues = ColorMapNode.preparaNoDataValues(candidateSD);
            SLDColorMapBuilder builder = new SLDColorMapBuilder();
            builder.setExtendedColors(this.extendedColors).setLinearColorMapType(this.type).setNumberColorMapEntries(cmEntries.length).setColorForValuesToPreserve(new Color(0, 0, 0, 0)).setGapsColor(new Color(0, 0, 0, 0));
            for (int i = 0; i < cmEntries.length; ++i) {
                builder.addColorMapEntry(cmEntries[i]);
            }
            if (candidateNoDataValues != null && candidateNoDataValues.length > 0) {
                LinearColorMapElement[] noDataCategories = new LinearColorMapElement[candidateNoDataValues.length];
                for (int i = 0; i < noDataCategories.length; ++i) {
                    builder.addValueToPreserve(candidateNoDataValues[i]);
                }
            }
            this.colorMapTransform = builder.buildLinearColorMap();
        } else {
            this.type = -1;
        }
    }

    private static double[] preparaNoDataValues(GridSampleDimension candidateSD) throws IllegalStateException {
        double[] candidateNoDataValues = candidateSD.getNoDataValues();
        if (candidateNoDataValues == null) {
            candidateNoDataValues = new double[1];
            SampleDimensionType sdType = candidateSD.getSampleDimensionType();
            int dataBufferType = TypeMap.getDataBufferType((SampleDimensionType)sdType);
            switch (dataBufferType) {
                case 2: {
                    candidateNoDataValues[0] = -32768.0;
                    break;
                }
                case 3: {
                    candidateNoDataValues[0] = -2.147483648E9;
                    break;
                }
                case 4: {
                    candidateNoDataValues[0] = Double.NaN;
                    break;
                }
                case 5: 
                case 32: {
                    candidateNoDataValues[0] = Double.NaN;
                    break;
                }
                default: {
                    candidateNoDataValues = null;
                }
            }
        }
        return candidateNoDataValues;
    }

    public ColorMapNode() {
        this((Hints)null);
    }

    public ColorMapNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ColorMapNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a ColorMapTransform following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        CoverageProcessingNode sourceNode = this.getSource(0);
        GridCoverageRendererUtilities.ensureSourceNotNull(sourceNode, this.getName().toString());
        GridCoverage2D sourceCoverage = (GridCoverage2D)sourceNode.getOutput();
        GridCoverageRendererUtilities.ensureSourceNotNull(sourceCoverage, this.getName().toString());
        if (this.colorMapTransform != null) {
            RenderedImage sourceImage = sourceCoverage.getRenderedImage();
            GridCoverageRendererUtilities.ensureSourceNotNull(sourceImage, this.getName().toString());
            ParameterBlock pbj = new ParameterBlock();
            pbj.addSource(sourceImage).add(this.colorMapTransform);
            RenderedOp classified = JAI.create((String)"org.geotools.RasterClassifier", (ParameterBlock)pbj);
            int outputChannels = classified.getColorModel().getNumComponents();
            int numBands = classified.getSampleModel().getNumBands();
            assert (outputChannels == 1 || outputChannels == 3 || outputChannels == 4);
            GridSampleDimension[] sd = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)classified.getColorModel(), (int)i).name());
            }
            return this.getCoverageFactory().create((CharSequence)("color_mapped_" + sourceCoverage.getName().toString()), (RenderedImage)classified, sourceCoverage.getGridGeometry(), sd, new GridCoverage[]{sourceCoverage}, sourceCoverage.getProperties());
        }
        return sourceCoverage;
    }

    public boolean isExtendedColors() {
        return this.extendedColors;
    }

    static {
        try {
            if (JAI.getDefaultInstance().getOperationRegistry().getDescriptor(OperationDescriptor.class, "org.geotools.RasterClassifier") == null) {
                RasterClassifier.register(JAI.getDefaultInstance());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }
}

