/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public abstract class AbstractSymbolizer
implements Symbolizer {
    protected String name;
    protected Description description;
    protected Expression geometry;
    protected Unit<Length> unitOfMeasure;
    protected Map<String, String> options;

    protected AbstractSymbolizer() {
    }

    public AbstractSymbolizer(String name, Description description, Expression geometry, Unit<Length> unitOfMeasure) {
        this.name = name;
        this.description = description;
        this.geometry = geometry;
        this.unitOfMeasure = unitOfMeasure;
    }

    public AbstractSymbolizer(String name, Description description, String geometryPropertyName, Unit<Length> unitOfMeasure) {
        this.name = name;
        this.description = description;
        this.unitOfMeasure = unitOfMeasure;
        this.setGeometryPropertyName(geometryPropertyName);
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(org.opengis.style.Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setUnitOfMeasure(Unit<Length> uom) {
        this.unitOfMeasure = uom;
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @Override
    public Expression getGeometry() {
        return this.geometry;
    }

    @Override
    public void setGeometry(Expression geometry) {
        this.geometry = geometry;
    }

    @Override
    public String getGeometryPropertyName() {
        if (this.geometry instanceof PropertyName) {
            PropertyName pg = (PropertyName)this.geometry;
            return pg.getPropertyName();
        }
        return null;
    }

    @Override
    public void setGeometryPropertyName(String geometryPropertyName) {
        if (geometryPropertyName == null) {
            this.geometry = null;
        } else {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            this.geometry = ff.property(geometryPropertyName);
        }
    }

    @Override
    public boolean hasOption(String key) {
        return this.options != null && this.options.containsKey(key);
    }

    @Override
    public Map<String, String> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        return this.options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unitOfMeasure == null ? 0 : this.unitOfMeasure.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSymbolizer other = (AbstractSymbolizer)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.geometry == null ? other.geometry != null : !this.geometry.equals(other.geometry)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.unitOfMeasure == null ? other.unitOfMeasure != null : !this.unitOfMeasure.equals(other.unitOfMeasure)) {
            return false;
        }
        return !(this.options == null ? other.options != null && !other.options.isEmpty() : !this.options.equals(other.options) && this.options.isEmpty() && other.options != null);
    }
}

