/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.condition;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.condition.BeforeConditionAbortedException;
import uk.co.caprica.vlcj.player.condition.UnexpectedErrorConditionException;
import uk.co.caprica.vlcj.player.condition.UnexpectedFinishedConditionException;

public abstract class Condition<T>
extends MediaPlayerEventAdapter {
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicReference<ResultStatus> resultStatus = new AtomicReference();
    private final AtomicReference<T> result = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean();
    protected final MediaPlayer mediaPlayer;
    private boolean used;

    public Condition(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        mediaPlayer.addMediaPlayerEventListener(this);
    }

    public final T await() throws InterruptedException, UnexpectedErrorConditionException, UnexpectedFinishedConditionException {
        Logger.debug("await()", new Object[0]);
        if (!this.used) {
            this.used = true;
            if (this.onBefore()) {
                this.completionLatch.await();
                switch (this.resultStatus.get()) {
                    case NORMAL: {
                        this.onAfter(this.result.get());
                        return this.result.get();
                    }
                    case ERROR: {
                        throw new UnexpectedErrorConditionException();
                    }
                    case FINISHED: {
                        throw new UnexpectedFinishedConditionException();
                    }
                }
                throw new IllegalStateException("Unexpected result status: " + (Object)((Object)this.resultStatus.get()));
            }
            throw new BeforeConditionAbortedException();
        }
        throw new IllegalStateException("Can not re-use Condition instances, create a new instance instead");
    }

    protected final void ready() {
        Logger.debug("ready()", new Object[0]);
        this.ready(null);
    }

    protected final void ready(T result) {
        Logger.debug("ready(result={})", result);
        if (!this.finished.getAndSet(true)) {
            Logger.debug("Finished", new Object[0]);
            this.result.set(result);
            this.release(ResultStatus.NORMAL);
        } else {
            Logger.debug("Already finished", new Object[0]);
        }
    }

    protected final void error() {
        Logger.debug("error()", new Object[0]);
        this.release(ResultStatus.ERROR);
    }

    protected final void finished() {
        Logger.debug("finished()", new Object[0]);
        this.release(ResultStatus.FINISHED);
    }

    protected boolean onBefore() {
        return true;
    }

    protected void onAfter(T result) {
    }

    private void release(ResultStatus resultStatus) {
        this.mediaPlayer.removeMediaPlayerEventListener(this);
        this.resultStatus.set(resultStatus);
        this.completionLatch.countDown();
    }

    private static enum ResultStatus {
        NORMAL,
        ERROR,
        FINISHED;

    }
}

