/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class ReadTest {
    public static void main(String[] args) throws ImageReadException, IOException {
        System.err.println("ho");
        ReadTest.metadataExample(new File("/home/et/osm/dev/bugs/10745-exif/gar-fine.jpg"));
    }

    public static void metadataExample(File file) throws ImageReadException, IOException {
        IImageMetadata metadata = Imaging.getMetadata(file);
        if (metadata instanceof JpegImageMetadata) {
            TiffImageMetadata.GPSInfo gpsInfo;
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            System.out.println("file: " + file.getPath());
            ReadTest.printTagValue(jpegMetadata, TiffTagConstants.TIFF_TAG_XRESOLUTION);
            ReadTest.printTagValue(jpegMetadata, TiffTagConstants.TIFF_TAG_DATE_TIME);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_DATE_TIME_DIGITIZED);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_ISO);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_SHUTTER_SPEED_VALUE);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_APERTURE_VALUE);
            ReadTest.printTagValue(jpegMetadata, ExifTagConstants.EXIF_TAG_BRIGHTNESS_VALUE);
            ReadTest.printTagValue(jpegMetadata, GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            ReadTest.printTagValue(jpegMetadata, GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            ReadTest.printTagValue(jpegMetadata, GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            ReadTest.printTagValue(jpegMetadata, GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            ReadTest.printTagValue(jpegMetadata, GpsTagConstants.GPS_TAG_GPS_VERSION_ID);
            System.out.println();
            TiffImageMetadata exifMetadata = jpegMetadata.getExif();
            if (null != exifMetadata && null != (gpsInfo = exifMetadata.getGPS())) {
                String gpsDescription = gpsInfo.toString();
                double longitude = gpsInfo.getLongitudeAsDegreesEast();
                double latitude = gpsInfo.getLatitudeAsDegreesNorth();
                System.out.println("    GPS Description: " + gpsDescription);
                System.out.println("    GPS Longitude (Degrees East): " + longitude);
                System.out.println("    GPS Latitude (Degrees North): " + latitude);
            }
            TiffField gpsLatitudeRefField = jpegMetadata.findEXIFValueWithExactMatch(GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField gpsLatitudeField = jpegMetadata.findEXIFValueWithExactMatch(GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField gpsLongitudeRefField = jpegMetadata.findEXIFValueWithExactMatch(GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField gpsLongitudeField = jpegMetadata.findEXIFValueWithExactMatch(GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            if (gpsLatitudeRefField != null && gpsLatitudeField != null && gpsLongitudeRefField != null && gpsLongitudeField != null) {
                String gpsLatitudeRef = (String)gpsLatitudeRefField.getValue();
                RationalNumber[] gpsLatitude = (RationalNumber[])gpsLatitudeField.getValue();
                String gpsLongitudeRef = (String)gpsLongitudeRefField.getValue();
                RationalNumber[] gpsLongitude = (RationalNumber[])gpsLongitudeField.getValue();
                RationalNumber gpsLatitudeDegrees = gpsLatitude[0];
                RationalNumber gpsLatitudeMinutes = gpsLatitude[1];
                RationalNumber gpsLatitudeSeconds = gpsLatitude[2];
                RationalNumber gpsLongitudeDegrees = gpsLongitude[0];
                RationalNumber gpsLongitudeMinutes = gpsLongitude[1];
                RationalNumber gpsLongitudeSeconds = gpsLongitude[2];
                System.out.println("    GPS Latitude: " + gpsLatitudeDegrees.toDisplayString() + " degrees, " + gpsLatitudeMinutes.toDisplayString() + " minutes, " + gpsLatitudeSeconds.toDisplayString() + " seconds " + gpsLatitudeRef);
                System.out.println("    GPS Longitude: " + gpsLongitudeDegrees.toDisplayString() + " degrees, " + gpsLongitudeMinutes.toDisplayString() + " minutes, " + gpsLongitudeSeconds.toDisplayString() + " seconds " + gpsLongitudeRef);
            }
            System.out.println();
            List<IImageMetadata.IImageMetadataItem> items = jpegMetadata.getItems();
            for (int i = 0; i < items.size(); ++i) {
                IImageMetadata.IImageMetadataItem item = items.get(i);
                System.out.println("    item: " + item);
            }
            System.out.println();
        }
    }

    private static void printTagValue(JpegImageMetadata jpegMetadata, TagInfo tagInfo) {
        TiffField field = jpegMetadata.findEXIFValueWithExactMatch(tagInfo);
        if (field == null) {
            System.out.println(tagInfo.name + ": " + "Not Found.");
        } else {
            System.out.println(tagInfo.name + ": " + field.getValueDescription());
        }
    }
}

