/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;

public class TRDFS {
    private final ArrayList<Channel> vertices;
    private Channel startNode;
    private final ArrayList<LeadsTo> cycleEdges;
    private final ChannelDiGraph digraph;

    public TRDFS(ArrayList<Channel> adnodes, ChannelDiGraph digraph) {
        this.vertices = adnodes;
        this.digraph = digraph;
        this.cycleEdges = new ArrayList();
    }

    public void trdfs(Channel startNode) {
        startNode.setVisited(0);
        startNode.addReachableNode(startNode);
        startNode.appendChannelToPath(startNode, startNode);
        for (int i = 0; i < startNode.getLeadsTo().size(); ++i) {
            Channel succNode = startNode.getLeadsTo().get(i).getToChannel();
            if (!succNode.isSubgraph()) continue;
            if (succNode.getVisited() == -1) {
                this.digraph.setForwardEdge(startNode, succNode);
                this.trdfs(succNode);
            } else if (succNode.getVisited() == 0) {
                this.cycleEdges.add(this.digraph.getLeadsTo(startNode, succNode));
            }
            for (int j = 0; j < succNode.getReachableNodes().size(); ++j) {
                startNode.addReachableNode(succNode.getReachableNodeAt(j));
                succNode.appendChannelToPath(succNode.getReachableNodeAt(j), succNode.getReachableNodeAt(j));
                succNode.appendChannelToPath(succNode.getReachableNodeAt(j), succNode);
                startNode.appendPath(succNode.getReachableNodeAt(j), succNode.getPathsAt(succNode.getReachableNodeAt(j)));
            }
        }
        startNode.setVisited(1);
    }

    public void ereaseCycleEdges() {
        this.cycleEdges.clear();
    }

    public int getCycleedgesSize() {
        return this.cycleEdges.size();
    }

    public LeadsTo getCycleEdgeAt(int i) {
        return this.cycleEdges.get(i);
    }

    public ArrayList<LeadsTo> getCycleEdges() {
        return this.cycleEdges;
    }
}

