/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime;

import uk.co.caprica.vlcj.logger.Logger;

public final class RuntimeUtil {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    private RuntimeUtil() {
    }

    public static boolean isNix() {
        return OS_NAME.indexOf("nux") != -1 || OS_NAME.indexOf("nix") != -1 || OS_NAME.indexOf("freebsd") != -1;
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("win") != -1;
    }

    public static boolean isMac() {
        return OS_NAME.indexOf("mac") != -1;
    }

    public static int safeLongToInt(long value) {
        Logger.debug("nativeComponentId={}", value);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            Logger.warn("Native component id is too big for int", new Object[0]);
            throw new IllegalArgumentException("long value " + value + " cannot be safely converted to an int.");
        }
        return (int)value;
    }

    public static String getLibVlcLibraryName() {
        return RuntimeUtil.isWindows() ? "libvlc" : "vlc";
    }

    public static String getLibVlcName() {
        if (RuntimeUtil.isNix()) {
            return "libvlc.so";
        }
        if (RuntimeUtil.isWindows()) {
            return "libvlc.dll";
        }
        if (RuntimeUtil.isMac()) {
            return "libvlc.dylib";
        }
        throw new RuntimeException("Unknown operating system");
    }

    public static String getLibVlcCoreName() {
        if (RuntimeUtil.isNix()) {
            return "libvlccore.so";
        }
        if (RuntimeUtil.isWindows()) {
            return "libvlccore.dll";
        }
        if (RuntimeUtil.isMac()) {
            return "libvlccore.dylib";
        }
        throw new RuntimeException("Unknown operating system");
    }

    public static String getPluginsDirectoryName() {
        if (!RuntimeUtil.isWindows()) {
            return "vlc/plugins";
        }
        return "plugins";
    }
}

