/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.windows;

import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.windows.Win32FullScreenHandler;

public final class Win32FullScreenStrategy
implements FullScreenStrategy {
    private final Win32FullScreenHandler handler;
    private boolean isFullScreenMode;

    public Win32FullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.handler = new Win32FullScreenHandler(window);
    }

    @Override
    public void enterFullScreenMode() {
        if (!this.isFullScreenMode) {
            this.handler.setFullScreen(true);
            this.isFullScreenMode = true;
        }
    }

    @Override
    public void exitFullScreenMode() {
        if (this.isFullScreenMode) {
            this.handler.setFullScreen(false);
            this.isFullScreenMode = false;
        }
    }

    @Override
    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }
}

