/*
 * Decompiled with CFR 0.152.
 */
package mergeoverlap.hack;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mergeoverlap.hack.MyRelationMemberConflictResolverModel;
import mergeoverlap.hack.MyRelationMemberConflictResolverTable;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MyRelationMemberConflictResolver
extends JPanel {
    private AutoCompletingTextField tfRole;
    private AutoCompletingTextField tfKey;
    private AutoCompletingTextField tfValue;
    private JCheckBox cbTagRelations;
    private MyRelationMemberConflictResolverModel model;
    private MyRelationMemberConflictResolverTable tblResolver;
    private JMultilineLabel lblHeader;

    protected final void build() {
        this.setLayout(new GridBagLayout());
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.lblHeader = new JMultilineLabel("");
        pnl.add((Component)this.lblHeader);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)pnl, gc);
        this.model = new MyRelationMemberConflictResolverModel();
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(0, 0, 0, 0);
        this.tblResolver = new MyRelationMemberConflictResolverTable(this.model);
        this.add((Component)new JScrollPane(this.tblResolver), gc);
        pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(this.buildRoleEditingPanel());
        pnl.add(this.buildTagRelationsPanel());
        gc.gridy = 2;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add((Component)pnl, gc);
    }

    protected JPanel buildRoleEditingPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        pnl.add(new JLabel(I18n.tr((String)"Role:", (Object[])new Object[0])));
        this.tfRole = new AutoCompletingTextField(10);
        pnl.add((Component)this.tfRole);
        this.tfRole.setToolTipText(I18n.tr((String)"Enter a role for all relation memberships", (Object[])new Object[0]));
        pnl.add(new JButton(new ApplyRoleAction()));
        this.tfRole.addActionListener((ActionListener)new ApplyRoleAction());
        this.tfRole.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MyRelationMemberConflictResolver.this.tfRole.selectAll();
            }
        });
        return pnl;
    }

    protected JPanel buildTagRelationsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.cbTagRelations = new JCheckBox(I18n.tr((String)"Tag modified relations with ", (Object[])new Object[0]));
        this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
        this.cbTagRelations.setToolTipText(I18n.tr((String)"<html>Select to enable entering a tag which will be applied<br>to all modified relations.</html>", (Object[])new Object[0]));
        pnl.add(this.cbTagRelations);
        pnl.add(new JLabel(I18n.trc((String)"tag", (String)"Key:")));
        this.tfKey = new AutoCompletingTextField(10);
        pnl.add((Component)this.tfKey);
        this.tfKey.setToolTipText(I18n.tr((String)"<html>Enter a tag key, e.g. <strong><tt>fixme</tt></strong></html>", (Object[])new Object[0]));
        pnl.add(new JLabel(I18n.tr((String)"Value:", (Object[])new Object[0])));
        this.tfValue = new AutoCompletingTextField(10);
        pnl.add((Component)this.tfValue);
        this.tfValue.setToolTipText(I18n.tr((String)"<html>Enter a tag value, e.g. <strong><tt>check members</tt></strong></html>", (Object[])new Object[0]));
        this.cbTagRelations.setSelected(false);
        this.tfKey.setEnabled(false);
        this.tfValue.setEnabled(false);
        return pnl;
    }

    public MyRelationMemberConflictResolver() {
        this.build();
    }

    public void initForWayCombining() {
        this.lblHeader.setText(I18n.tr((String)"<html>The combined ways are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the combined way or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first way and <strong>remove</strong> the other ways that are members of the same relation: the combined way will take the place of the original way in the relation.</html>", (Object[])new Object[0]));
        this.invalidate();
    }

    public void initForNodeMerging() {
        this.lblHeader.setText(I18n.tr((String)"<html>The merged nodes are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the target node or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first node and <strong>remove</strong> the other nodes that are members of the same relation: the target node will take the place of the original node in the relation.</html>", (Object[])new Object[0]));
        this.invalidate();
    }

    public MyRelationMemberConflictResolverModel getModel() {
        return this.model;
    }

    public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> primitives) {
        if (!this.cbTagRelations.isSelected()) {
            return null;
        }
        if (this.tfKey.getText().trim().isEmpty()) {
            return null;
        }
        if (this.tfValue.getText().trim().isEmpty()) {
            return null;
        }
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(primitives, Tag.removeWhiteSpaces((String)this.tfKey.getText()), Tag.removeWhiteSpaces((String)this.tfValue.getText()));
    }

    public void prepareForEditing() {
        AutoCompletionList acList = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithMemberRoles(acList);
        this.tfRole.setAutoCompletionList(acList);
        AutoCompletingTextField editor = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
        if (editor != null) {
            editor.setAutoCompletionList(acList);
        }
        AutoCompletionList acList2 = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithKeys(acList2);
        this.tfKey.setAutoCompletionList(acList2);
    }

    class ToggleTagRelationsAction
    implements ChangeListener {
        ToggleTagRelationsAction() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ButtonModel buttonModel = ((AbstractButton)e.getSource()).getModel();
            MyRelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
            MyRelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
            MyRelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            MyRelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
        }
    }

    class ApplyRoleAction
    extends AbstractAction {
        public ApplyRoleAction() {
            this.putValue("Name", I18n.tr((String)"Apply", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.putValue("ShortDescription", I18n.tr((String)"Apply this role to all members", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MyRelationMemberConflictResolver.this.model.applyRole(MyRelationMemberConflictResolver.this.tfRole.getText());
        }
    }
}

