/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.NeptuneReader;
import org.openstreetmap.josm.tools.I18n;

public class XmlImporter
extends AbstractImporter {
    public static final ExtensionFileFilter XML_FILE_FILTER = new ExtensionFileFilter("xml", "xml", I18n.tr((String)"OpenData XML files", (Object[])new Object[0]) + " (*." + "xml" + ")");

    public XmlImporter() {
        super(XML_FILE_FILTER);
    }

    public boolean acceptFile(File pathname) {
        if (super.acceptFile(pathname)) {
            for (URL schemaURL : NeptuneReader.getSchemas()) {
                if (!NeptuneReader.acceptsXmlNeptuneFile(pathname, schemaURL)) continue;
                return true;
            }
        }
        return false;
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IllegalDataException {
        try {
            return NeptuneReader.parseDataSet(in, this.handler, instance);
        }
        catch (JAXBException e) {
            throw new IllegalDataException((Throwable)e);
        }
    }
}

