/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.OverpassApi;

public abstract class SimpleDataSetHandler
extends AbstractDataSetHandler {
    protected static final Projection wgs84 = OdConstants.PRJ_WGS84.getProjection();
    private final List<Tag> relevantTags = new ArrayList<Tag>();
    private final List<Tag> forbiddenTags = new ArrayList<Tag>();
    private final boolean relevantUnion;

    public SimpleDataSetHandler() {
        this.relevantUnion = false;
    }

    public SimpleDataSetHandler(String relevantTag) {
        this.addRelevantTag(relevantTag);
        this.relevantUnion = false;
        String[] kv = relevantTag.split("=");
        Tag tag = kv != null && kv.length == 2 ? new Tag(kv[0], kv[1]) : new Tag(relevantTag);
        this.setMenuIcon(MapPaintStyles.getNodeIcon((Tag)tag));
    }

    public SimpleDataSetHandler(boolean relevantUnion, String ... relevantTags) {
        this.addRelevantTag(relevantTags);
        this.relevantUnion = relevantUnion;
    }

    public SimpleDataSetHandler(String ... relevantTags) {
        this(false, relevantTags);
    }

    public SimpleDataSetHandler(Tag relevantTag) {
        this.addRelevantTag(relevantTag);
        this.relevantUnion = false;
    }

    public SimpleDataSetHandler(boolean relevantUnion, Tag ... relevantTags) {
        this.addRelevantTag(relevantTags);
        this.relevantUnion = relevantUnion;
    }

    public SimpleDataSetHandler(Tag ... relevantTags) {
        this(false, relevantTags);
    }

    public void addRelevantTag(String ... relevantTags) {
        this.addTags(this.relevantTags, relevantTags);
    }

    public void addRelevantTag(Tag ... relevantTags) {
        this.addTags(this.relevantTags, relevantTags);
    }

    public void addForbiddenTag(String ... forbiddenTags) {
        this.addTags(this.forbiddenTags, forbiddenTags);
    }

    public void addForbiddenTag(Tag ... forbiddenTags) {
        this.addTags(this.forbiddenTags, forbiddenTags);
    }

    private final void addTags(List<Tag> list, String ... tags) {
        if (tags != null) {
            for (String tag : tags) {
                if (tag == null) continue;
                if (tag.contains("=")) {
                    String[] tab = tag.split("=");
                    list.add(new Tag(tab[0], tab[1]));
                    continue;
                }
                list.add(new Tag(tag));
            }
        }
    }

    private final void addTags(List<Tag> list, Tag ... tags) {
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag == null) continue;
                list.add(tag);
            }
        }
    }

    @Override
    public boolean equals(IPrimitive p1, IPrimitive p2) {
        for (Tag tag : this.relevantTags) {
            if (p1.get(tag.getKey()).equals(p2.get(tag.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRelevant(IPrimitive p) {
        for (Tag tag : this.relevantTags) {
            String value = p.get(tag.getKey());
            if (value != null && (tag.getValue() == null || tag.getValue().equals(value))) continue;
            return false;
        }
        return !this.isForbidden(p);
    }

    @Override
    public boolean isForbidden(IPrimitive p) {
        for (Tag tag : this.forbiddenTags) {
            String value = p.get(tag.getKey());
            if (value == null || tag.getValue() != null && !tag.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasForbiddenTags() {
        return !this.forbiddenTags.isEmpty();
    }

    protected final String[] getOverpassApiConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        for (Tag tag : this.relevantTags) {
            conditions.add(OverpassApi.hasKey(tag.getKey(), tag.getValue()));
        }
        return conditions.toArray(new String[0]);
    }

    protected String getOverpassApiQueries(String bbox, String ... conditions) {
        String[] mpconditions = new String[conditions.length + 1];
        mpconditions[0] = OverpassApi.hasKey("type", "multipolygon");
        for (int i = 0; i < conditions.length; ++i) {
            mpconditions[i + 1] = conditions[i];
        }
        return OverpassApi.query(bbox, OverpassApi.OaQueryType.NODE, conditions) + "\n" + OverpassApi.recurse(OverpassApi.OaRecurseType.NODE_RELATION, OverpassApi.OaRecurseType.RELATION_WAY, OverpassApi.OaRecurseType.WAY_NODE) + "\n" + OverpassApi.query(bbox, OverpassApi.OaQueryType.WAY, conditions) + "\n" + OverpassApi.recurse(OverpassApi.OaRecurseType.WAY_NODE, "nodes") + "\n" + OverpassApi.recurse(OverpassApi.OaRecurseType.WAY_RELATION, OverpassApi.OaRecurseType.RELATION_WAY, OverpassApi.OaRecurseType.WAY_NODE) + "\n" + OverpassApi.query(bbox, OverpassApi.OaQueryType.RELATION, mpconditions) + "\n" + OverpassApi.recurse(OverpassApi.OaRecurseType.RELATION_WAY, OverpassApi.OaRecurseType.WAY_NODE);
    }

    @Override
    protected String getOverpassApiRequest(String bbox) {
        String result = "";
        if (this.relevantUnion) {
            for (Tag tag : this.relevantTags) {
                result = result + this.getOverpassApiQueries(bbox, OverpassApi.hasKey(tag.getKey(), tag.getValue()));
            }
            result = OverpassApi.union(result);
        } else {
            result = OverpassApi.union(this.getOverpassApiQueries(bbox, this.getOverpassApiConditions()));
        }
        return result + OverpassApi.print();
    }

    @Override
    protected Collection<String> getOsmXapiRequests(String bbox) {
        String relevantTags = "";
        for (Tag tag : this.relevantTags) {
            relevantTags = relevantTags + "[" + tag.getKey() + "=" + (tag.getValue() == null ? "*" : tag.getValue()) + "]";
        }
        String forbiddenTags = "";
        for (Tag tag : this.forbiddenTags) {
            forbiddenTags = forbiddenTags + "[not(" + tag.getKey() + "=" + (tag.getValue() == null ? "*" : tag.getValue()) + ")]";
        }
        return Collections.singleton("*[bbox=" + bbox + "]" + relevantTags + forbiddenTags + "[@meta]");
    }
}

