/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetReader;

public class XlsReader
extends SpreadSheetReader {
    private Workbook wb;
    private Sheet sheet;
    private int rowIndex;

    public XlsReader(SpreadSheetHandler handler) {
        super(handler);
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new XlsReader(handler != null ? handler.getSpreadSheetHandler() : null).parse(in, instance);
    }

    @Override
    protected void initResources(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        Main.info((String)"Parsing XLS file");
        try {
            this.wb = new HSSFWorkbook(new POIFSFileSystem(in));
            this.sheet = this.wb.getSheetAt(this.getSheetNumber());
            this.rowIndex = 0;
        }
        catch (ExceptionInInitializerError e) {
            Throwable ex = e.getException();
            if (ex != null && ex.getMessage() != null) {
                System.err.println(ex.getClass() + ": " + ex.getMessage());
            }
            throw new IOException(e);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    protected String[] readLine(ProgressMonitor progressMonitor) throws IOException {
        Row row;
        if (this.sheet != null && (row = this.sheet.getRow(this.rowIndex++)) != null) {
            ArrayList<String> result = new ArrayList<String>();
            block6: for (Cell cell : row) {
                switch (cell.getCellType()) {
                    case 1: {
                        result.add(cell.getRichStringCellValue().getString());
                        continue block6;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted(cell)) {
                            result.add(cell.getDateCellValue().toString());
                            continue block6;
                        }
                        result.add(Double.toString(cell.getNumericCellValue()));
                        continue block6;
                    }
                    case 4: {
                        result.add(Boolean.toString(cell.getBooleanCellValue()));
                        continue block6;
                    }
                    case 2: {
                        result.add(cell.getCellFormula());
                        continue block6;
                    }
                }
                result.add("");
            }
            return result.toArray(new String[0]);
        }
        return null;
    }
}

