/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;

public class CoordinateSequences
extends com.vividsolutions.jts.geom.CoordinateSequences {
    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        double hiy = ring.getOrdinate(0, 1);
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            if (!(ring.getOrdinate(i, 1) > hiy)) continue;
            hiy = ring.getOrdinate(i, 1);
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (CoordinateSequences.equals2D(ring, iPrev, hiIndex) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (CoordinateSequences.equals2D(ring, iNext = (iNext + 1) % nPts, hiIndex) && iNext != hiIndex) {
        }
        if (CoordinateSequences.equals2D(ring, iPrev, hiIndex) || CoordinateSequences.equals2D(ring, iNext, hiIndex) || CoordinateSequences.equals2D(ring, iPrev, iNext)) {
            return false;
        }
        int disc = CoordinateSequences.computeOrientation(ring, iPrev, hiIndex, iNext);
        boolean isCCW = false;
        isCCW = disc == 0 ? ring.getOrdinate(iPrev, 0) > ring.getOrdinate(iNext, 0) : disc > 0;
        return isCCW;
    }

    private static boolean equals2D(CoordinateSequence cs, int i, int j) {
        return cs.getOrdinate(i, 0) == cs.getOrdinate(j, 0) && cs.getOrdinate(i, 1) == cs.getOrdinate(j, 1);
    }

    public static int computeOrientation(CoordinateSequence cs, int p1, int p2, int q) {
        double p1x = cs.getOrdinate(p1, 0);
        double p1y = cs.getOrdinate(p1, 1);
        double p2x = cs.getOrdinate(p2, 0);
        double p2y = cs.getOrdinate(p2, 1);
        double qx = cs.getOrdinate(q, 0);
        double qy = cs.getOrdinate(q, 1);
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        double dx2 = qx - p2x;
        double dy2 = qy - p2y;
        return RobustDeterminant.signOfDet2x2((double)dx1, (double)dy1, (double)dx2, (double)dy2);
    }

    public static int coordinateDimension(Geometry g) {
        if (g instanceof Point) {
            return CoordinateSequences.coordinateDimension(((Point)g).getCoordinateSequence());
        }
        if (g instanceof LineString) {
            return CoordinateSequences.coordinateDimension(((LineString)g).getCoordinateSequence());
        }
        if (g instanceof Polygon) {
            return CoordinateSequences.coordinateDimension(((Polygon)g).getExteriorRing().getCoordinateSequence());
        }
        CoordinateSequence cs = CoordinateSequenceFinder.find(g);
        return CoordinateSequences.coordinateDimension(cs);
    }

    public static int coordinateDimension(CoordinateSequence seq) {
        if (seq == null) {
            return 3;
        }
        int dim = seq.getDimension();
        if (dim != 3) {
            return dim;
        }
        if (seq instanceof CoordinateArraySequence && seq.size() > 0) {
            if (Double.isNaN(seq.getOrdinate(0, 1))) {
                return 1;
            }
            if (Double.isNaN(seq.getOrdinate(0, 2))) {
                return 2;
            }
        }
        return 3;
    }

    private static class CoordinateSequenceFinder
    implements CoordinateSequenceFilter {
        private CoordinateSequence firstSeqFound = null;

        private CoordinateSequenceFinder() {
        }

        public static CoordinateSequence find(Geometry g) {
            CoordinateSequenceFinder finder = new CoordinateSequenceFinder();
            g.apply((CoordinateSequenceFilter)finder);
            return finder.getSeq();
        }

        public CoordinateSequence getSeq() {
            return this.firstSeqFound;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (this.firstSeqFound == null) {
                this.firstSeqFound = seq;
            }
        }

        public boolean isDone() {
            return this.firstSeqFound != null;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

