/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2.server;

import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;
import org.openstreetmap.josm.plugins.tracer2.server.Request;

public class GetTrace
extends Request {
    private LatLon m_oLatLon;
    private ServerParam m_oServerParam;
    public ArrayList<LatLon> m_listLatLon = new ArrayList();

    public GetTrace(LatLon oLatLon, ServerParam oParam) {
        this.m_oLatLon = oLatLon;
        this.m_oServerParam = oParam;
    }

    @Override
    public void run() {
        try {
            String[] astrPoints;
            String strResponse = this.callServer("traceOrder=GetTrace&traceLat=" + this.m_oLatLon.lat() + "&traceLon=" + this.m_oLatLon.lon() + "&traceName=" + this.m_oServerParam.getName() + "&traceUrl=" + this.m_oServerParam.getUrl() + "&traceTileSize=" + this.m_oServerParam.getTileSize() + "&traceResolution=" + this.m_oServerParam.getResolution() + "&traceMode=" + this.m_oServerParam.getMode() + "&traceThreshold=" + this.m_oServerParam.getThreshold() + "&tracePointsPerCircle=" + this.m_oServerParam.getPointsPerCircle());
            if (strResponse == null || strResponse.equals("")) {
                return;
            }
            if (this.checkError(strResponse)) {
                return;
            }
            if (!strResponse.startsWith("(") || !strResponse.endsWith(")")) {
                return;
            }
            strResponse = strResponse.substring(1, strResponse.length() - 1);
            ArrayList<LatLon> nodelist = new ArrayList<LatLon>();
            for (String strPoint : astrPoints = strResponse.split("\\)\\(")) {
                String[] astrParts = strPoint.split(":");
                double x = Double.parseDouble(astrParts[0]);
                double y = Double.parseDouble(astrParts[1]);
                nodelist.add(new LatLon(x, y));
            }
            this.m_listLatLon = nodelist;
        }
        catch (Exception e) {
            this.m_listLatLon = new ArrayList();
        }
    }
}

