/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.ac;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.I18n;

public class AutoCompletionListRenderer
extends JLabel
implements TableCellRenderer {
    public static final String RES_OSM_ICON = "/resources/osm.png";
    public static final String RES_SELECTION_ICON = "/resources/selection.png";
    private Icon iconStandard;
    private Icon iconSelection;

    public AutoCompletionListRenderer() {
        this.setOpaque(true);
        this.loadIcons();
    }

    protected void loadIcons() {
        URL imgURL = this.getClass().getResource(RES_OSM_ICON);
        if (imgURL != null) {
            this.iconStandard = new ImageIcon(imgURL);
        } else {
            System.err.println("Could not load icon: /resources/osm.png");
            this.iconStandard = null;
        }
        imgURL = this.getClass().getResource(RES_SELECTION_ICON);
        if (imgURL != null) {
            this.iconSelection = new ImageIcon(imgURL);
        } else {
            System.err.println("Could not load icon: /resources/selection.png");
            this.iconSelection = null;
        }
    }

    protected void prepareRendererIcon(AutoCompletionListItem item) {
        if (item.getPriority().equals(AutoCompletionItemPriority.IS_IN_STANDARD)) {
            if (this.iconStandard != null) {
                this.setIcon(this.iconStandard);
            }
        } else if (item.getPriority().equals(AutoCompletionItemPriority.IS_IN_SELECTION) && this.iconSelection != null) {
            this.setIcon(this.iconSelection);
        }
    }

    protected void resetRenderer() {
        this.setIcon(null);
        this.setText("");
        this.setFont(UIManager.getFont("Table.font"));
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
    }

    protected void renderSelected() {
        this.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.setForeground(UIManager.getColor("Table.selectionForeground"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.resetRenderer();
        if (value instanceof AutoCompletionListItem) {
            AutoCompletionListItem item = (AutoCompletionListItem)value;
            this.prepareRendererIcon(item);
            this.setText(item.getValue());
            this.setToolTipText(item.getValue());
        } else if (value != null) {
            this.setText(value.toString());
            this.setToolTipText(value.toString());
        } else {
            this.setText(I18n.tr((String)"unknown", (Object[])new Object[0]));
            this.setFont(this.getFont().deriveFont(2));
        }
        if (isSelected) {
            this.renderSelected();
        }
        return this;
    }
}

