/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.logger.Logger;

public final class MediaResourceLocator {
    private static final Pattern MRL_LOCATION_PATTERN = Pattern.compile(".+://.*");

    private MediaResourceLocator() {
    }

    public static boolean isLocation(String mrl) {
        return MRL_LOCATION_PATTERN.matcher(mrl).matches();
    }

    public static String encodeMrl(String mrl) {
        String result;
        block5: {
            Logger.debug("encodeMrl(mrl={})", mrl);
            result = mrl;
            if (MediaResourceLocator.containsUnicode(mrl)) {
                Logger.debug("MRL contains Unicode characters", new Object[0]);
                try {
                    URI uri = new URI(mrl);
                    Logger.debug("uri={}", uri);
                    String scheme = uri.getScheme();
                    Logger.debug("scheme={}", uri.getScheme());
                    if (scheme == null) {
                        Logger.debug("MRL has no scheme, assuming a local file name that should be encoded", new Object[0]);
                        result = new File(mrl).toURI().toASCIIString().replaceFirst("file:/", "file:///");
                        break block5;
                    }
                    Logger.debug("Ignoring MRL with scheme '{}'", scheme);
                }
                catch (URISyntaxException e) {
                    Logger.debug("Can not obtain a valid URI from the MRL", new Object[0]);
                }
            } else {
                Logger.debug("MRL does not contain any Unicode characters", new Object[0]);
            }
        }
        Logger.debug("result={}", result);
        return result;
    }

    private static boolean containsUnicode(String value) {
        boolean result = false;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) < '\u0080') continue;
            result = true;
            break;
        }
        return result;
    }
}

