/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagerycache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Random;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileClearController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.plugins.imagerycache.DBTile;
import org.openstreetmap.josm.plugins.imagerycache.TileDAOMapDB;

class OsmDBTilesLoader
extends OsmTileLoader
implements CachedTileLoader {
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    public static final boolean debug = new BooleanProperty("imagerycache.debug", false).get();
    TileDAOMapDB dao = TileDAOMapDB.getInstance();
    protected long maxCacheFileAge = 604800000L;
    protected long recheckAfter = 86400000L;

    public OsmDBTilesLoader(TileLoaderListener smap, File cacheFolder) {
        super(smap);
        this.dao.setCacheFolder(cacheFolder);
    }

    public TileJob createTileLoaderJob(Tile tile) {
        return new DatabaseLoadJob(tile);
    }

    public void clearCache(TileSource source) {
        this.clearCache(source, null);
    }

    public void clearCache(TileSource source, TileClearController controller) {
        this.dao.cleanStorage(source.getName());
    }

    protected class DatabaseLoadJob
    implements TileJob {
        private final Tile tile;
        File tileCacheDir;
        DBTile dbTile = null;
        long fileAge = 0L;
        long id;
        String sourceName;

        public DatabaseLoadJob(Tile tile) {
            this.tile = tile;
            this.id = 0x1000000L * (long)tile.getZoom() + 0x200000L * (long)tile.getXtile() + (long)tile.getYtile();
            this.sourceName = tile.getSource().getName();
        }

        public Tile getTile() {
            return this.tile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Tile tile = this.tile;
            synchronized (tile) {
                if (this.tile.isLoaded() && !this.tile.hasError() || this.tile.isLoading()) {
                    return;
                }
                this.tile.initLoading();
            }
            if (this.loadTileFromFile()) {
                return;
            }
            if (this.dbTile != null) {
                TileJob job = new TileJob(){

                    public void run() {
                        DatabaseLoadJob.this.loadOrUpdateTileFromServer();
                    }

                    public Tile getTile() {
                        return DatabaseLoadJob.this.tile;
                    }
                };
                JobDispatcher.getInstance().addJob(job);
            } else {
                this.loadOrUpdateTileFromServer();
            }
        }

        private boolean loadTileFromFile() {
            ByteArrayInputStream bin = null;
            try {
                boolean oldTile;
                this.dbTile = OsmDBTilesLoader.this.dao.getById(this.sourceName, this.id);
                if (this.dbTile == null) {
                    return false;
                }
                this.loadMetadata();
                if (debug) {
                    System.out.println(this.id + ": found in cache, metadata =" + this.dbTile.metaData);
                }
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                    OsmDBTilesLoader.this.dao.deleteTile(this.sourceName, this.id);
                } else {
                    bin = new ByteArrayInputStream(this.dbTile.data);
                    if (bin.available() == 0) {
                        throw new IOException("Data empty");
                    }
                    this.tile.loadImage((InputStream)bin);
                    bin.close();
                }
                this.fileAge = this.dbTile.lastModified;
                boolean bl = oldTile = System.currentTimeMillis() - this.fileAge > OsmDBTilesLoader.this.maxCacheFileAge;
                if (!oldTile) {
                    this.tile.setLoaded(true);
                    OsmDBTilesLoader.this.listener.tileLoadingFinished(this.tile, true);
                    return true;
                }
                OsmDBTilesLoader.this.listener.tileLoadingFinished(this.tile, true);
                return false;
            }
            catch (Exception e) {
                Main.error((String)("Error: Can not load tile from database: " + this.sourceName + ":" + this.id));
                Main.error((Throwable)e);
                try {
                    if (bin != null) {
                        bin.close();
                        OsmDBTilesLoader.this.dao.deleteTile(this.sourceName, this.id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dbTile = null;
                this.fileAge = 0L;
                return false;
            }
            catch (Error e) {
                Main.error((String)("Serious database error: Can not load tile from database: " + this.sourceName + ":" + this.id));
                Main.error((Throwable)e);
                this.dbTile = null;
                this.fileAge = 0L;
                return false;
            }
        }

        long getLastModTime() {
            return System.currentTimeMillis() - OsmDBTilesLoader.this.maxCacheFileAge + OsmDBTilesLoader.this.recheckAfter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadOrUpdateTileFromServer() {
            block28: {
                try {
                    URLConnection urlConn = OsmDBTilesLoader.this.loadTileFromOsm(this.tile);
                    TileSource.TileUpdate tileUpdate = this.tile.getSource().getTileUpdate();
                    if (this.dbTile != null) {
                        this.dbTile = new DBTile(this.dbTile);
                        switch (tileUpdate) {
                            case IfModifiedSince: {
                                urlConn.setIfModifiedSince(this.fileAge);
                                break;
                            }
                            case LastModified: {
                                if (this.isOsmTileNewer(this.fileAge)) break;
                                System.out.println("Tile " + this.id + ": LastModified test: local version is up to date");
                                this.dbTile.lastModified = this.getLastModTime();
                                OsmDBTilesLoader.this.dao.updateModTime(this.sourceName, this.id, this.dbTile);
                                return;
                            }
                        }
                    } else {
                        this.dbTile = new DBTile();
                    }
                    if (tileUpdate == TileSource.TileUpdate.ETag || tileUpdate == TileSource.TileUpdate.IfNoneMatch) {
                        String fileETag = this.tile.getValue("etag");
                        if (fileETag != null) {
                            switch (tileUpdate) {
                                case IfNoneMatch: {
                                    urlConn.addRequestProperty("If-None-Match", fileETag);
                                    break;
                                }
                                case ETag: {
                                    if (!this.hasOsmTileETag(fileETag)) break;
                                    this.dbTile.lastModified = this.getLastModTime();
                                    OsmDBTilesLoader.this.dao.updateModTime(this.sourceName, this.id, this.dbTile);
                                    return;
                                }
                            }
                        }
                        this.tile.putValue("etag", urlConn.getHeaderField("ETag"));
                    }
                    if (urlConn instanceof HttpURLConnection && ((HttpURLConnection)urlConn).getResponseCode() == 304) {
                        if (debug) {
                            System.out.println("Tile " + this.id + ": Answer from HTTP=304 / ETag test: local version is up to date");
                        }
                        this.dbTile.lastModified = this.getLastModTime();
                        OsmDBTilesLoader.this.dao.updateModTime(this.sourceName, this.id, this.dbTile);
                        return;
                    }
                    OsmDBTilesLoader.this.loadTileMetadata(this.tile, urlConn);
                    this.dbTile.metaData = this.tile.getMetadata();
                    if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                        this.tile.setError("No tile at this zoom level");
                        OsmDBTilesLoader.this.listener.tileLoadingFinished(this.tile, true);
                        break block28;
                    }
                    for (int i = 0; i < 5; ++i) {
                        byte[] buffer;
                        if (urlConn instanceof HttpURLConnection && ((HttpURLConnection)urlConn).getResponseCode() == 503) {
                            Thread.sleep(5000 + new Random().nextInt(5000));
                            continue;
                        }
                        if (debug) {
                            System.out.println("Tile " + this.id + ": Loading from OSM, " + this.tile);
                        }
                        if ((buffer = this.loadTileInBuffer(urlConn)) == null) continue;
                        this.tile.loadImage((InputStream)new ByteArrayInputStream(buffer));
                        this.tile.setLoaded(true);
                        this.dbTile.data = buffer;
                        this.dbTile.lastModified = System.currentTimeMillis();
                        OsmDBTilesLoader.this.dao.updateTile(this.sourceName, this.id, this.dbTile);
                        OsmDBTilesLoader.this.listener.tileLoadingFinished(this.tile, true);
                        break;
                    }
                }
                catch (Exception e) {
                    this.tile.setError(e.getMessage());
                    OsmDBTilesLoader.this.listener.tileLoadingFinished(this.tile, false);
                    try {
                        System.out.println("Error: Tile " + this.id + " can not be loaded from" + this.tile.getUrl());
                        e.printStackTrace(System.out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    this.tile.finishLoading();
                }
            }
        }

        protected byte[] loadTileInBuffer(URLConnection urlConn) throws IOException {
            InputStream input = urlConn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(input.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = input.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            if (bout.size() == 0) {
                return null;
            }
            return bout.toByteArray();
        }

        protected boolean isOsmTileNewer(long fileAge) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmDBTilesLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            long lastModified = urlConn.getLastModified();
            if (lastModified == 0L) {
                return true;
            }
            return lastModified > fileAge;
        }

        protected boolean hasOsmTileETag(String eTag) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmDBTilesLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            String osmETag = urlConn.getHeaderField("ETag");
            if (osmETag == null) {
                return true;
            }
            return osmETag.equals(eTag);
        }

        private void loadMetadata() {
            Map<String, String> m = this.dbTile.metaData;
            if (m == null) {
                return;
            }
            for (String k : m.keySet()) {
                this.tile.putValue(k, m.get(k));
            }
        }
    }
}

