/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.value;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RelevanceRange
implements Serializable,
Comparable<RelevanceRange> {
    private static final long serialVersionUID = -5187434838022942754L;
    public static final RelevanceRange LOW_RANGE = new RelevanceRange(0, 3);
    public static final RelevanceRange MID_LOW_RANGE = new RelevanceRange(4, 6);
    public static final RelevanceRange MEDIUM_RANGE = new RelevanceRange(7, 9);
    public static final RelevanceRange MID_HIGH_RANGE = new RelevanceRange(10, 13);
    public static final RelevanceRange HIGH_RANGE = new RelevanceRange(14, 17);
    private static Set<RelevanceRange> set;
    private int lowerValue;
    private int upperValue;

    private RelevanceRange() {
    }

    private RelevanceRange(int lowerValue, int upperValue) {
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        if (set == null) {
            set = new HashSet<RelevanceRange>();
        }
        set.add(this);
    }

    public static RelevanceRange getRelevanceRange(int value) {
        Iterator<RelevanceRange> it = set.iterator();
        RelevanceRange range = null;
        while (it.hasNext()) {
            range = it.next();
            if (value < range.getLowerValue() || value > range.getUpperValue()) continue;
            return range;
        }
        return null;
    }

    public int getLowerValue() {
        return this.lowerValue;
    }

    public int getUpperValue() {
        return this.upperValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lowerValue;
        result = 31 * result + this.upperValue;
        return result;
    }

    public boolean equals(Object obj) {
        RelevanceRange other = (RelevanceRange)obj;
        if (this.lowerValue != other.lowerValue) {
            return false;
        }
        return this.upperValue == other.upperValue;
    }

    @Override
    public int compareTo(RelevanceRange obj) {
        if (this.getLowerValue() < obj.getLowerValue() && this.getUpperValue() < obj.getUpperValue()) {
            return -1;
        }
        if (this.getLowerValue() > obj.getLowerValue() && this.getUpperValue() > obj.getUpperValue()) {
            return 1;
        }
        return 0;
    }
}

