/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.canvec_helper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.canvec_helper.CanVecTile;
import org.openstreetmap.josm.plugins.canvec_helper.CanvecHelper;
import org.openstreetmap.josm.plugins.canvec_helper.SetMaxZoom;
import org.openstreetmap.josm.tools.I18n;

class CanvecLayer
extends Layer {
    private Icon layerIcon = null;
    private int maxZoom = 4;
    final CanvecHelper plugin;
    private List<CanVecTile> tiles = new ArrayList<CanVecTile>();
    List<CanVecTile> downloadable = new ArrayList<CanVecTile>();
    List<CanVecTile> openable = new ArrayList<CanVecTile>();

    CanvecLayer(String name, CanvecHelper self) {
        super(name);
        this.plugin = self;
        this.setBackgroundLayer(true);
        this.layerIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(((Object)((Object)this)).getClass().getResource("/images/layericon.png")));
        long start = System.currentTimeMillis();
        try (InputStream index = new CachedFile("http://ftp2.cits.rncan.gc.ca/OSM/pub/ZippedOsm.txt").getInputStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(index, StandardCharsets.UTF_8));){
            String line;
            Pattern p = Pattern.compile("(\\d\\d\\d)([A-Z]\\d\\d).*");
            int lastCell = -1;
            ArrayList<String> list = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    int cell = Integer.parseInt(m.group(1));
                    if (cell == lastCell) {
                        list.add(m.group(0));
                    } else if (lastCell != -1) {
                        CanVecTile tile = new CanVecTile(lastCell, "", 0, "", this, list);
                        if (tile.isValid()) {
                            this.tiles.add(tile);
                        }
                        list = new ArrayList();
                        list.add(m.group(0));
                    }
                    lastCell = cell;
                    continue;
                }
                if (line.contains("Metadata.txt")) continue;
                Main.warn((String)("bad line '" + line + "'\n"));
            }
            CanVecTile tile = new CanVecTile(lastCell, "", 0, "", this, list);
            if (tile.isValid()) {
                this.tiles.add(tile);
            }
            if (Main.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                Main.debug((String)(end - start + "ms spent"));
            }
        }
        catch (IOException e) {
            Main.error((String)"exception getting index");
            Main.error((Throwable)e);
        }
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this), new MaxZoomAction(this), new DownloadCanvecAction(this), new OpenOsmAction(this)};
    }

    void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return I18n.tr((String)"canvec tile helper", (Object[])new Object[0]);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public Icon getIcon() {
        return this.layerIcon;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.downloadable = new ArrayList<CanVecTile>();
        this.openable = new ArrayList<CanVecTile>();
        g.setColor(Color.red);
        for (int i = 0; i < this.tiles.size(); ++i) {
            CanVecTile tile = this.tiles.get(i);
            tile.paint(g, mv, bounds, this.maxZoom);
        }
    }

    private class DownloadCanvecAction
    extends AbstractAction
    implements Layer.LayerAction {
        private CanvecLayer parent;

        private DownloadCanvecAction(CanvecLayer parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }

        public Component createMenuComponent() {
            JMenu downloadCanvec = new JMenu("Download zip's");
            for (int i = 0; i < this.parent.downloadable.size(); ++i) {
                downloadCanvec.add(new JMenuItem(new AllowDownload(this.parent.downloadable.get(i))));
            }
            return downloadCanvec;
        }
    }

    private static class DoOpenOsm
    extends AbstractAction {
        private final CanVecTile tile;

        private DoOpenOsm(CanVecTile tile) {
            super(tile.tileid);
            this.tile = tile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tile.loadRawOsm();
        }
    }

    private class OpenOsmAction
    extends AbstractAction
    implements Layer.LayerAction {
        private CanvecLayer layer;

        private OpenOsmAction(CanvecLayer layer) {
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public Component createMenuComponent() {
            JMenu openOsm = new JMenu("Open tile");
            for (int i = 0; i < this.layer.openable.size(); ++i) {
                openOsm.add(new JMenuItem(new DoOpenOsm(this.layer.openable.get(i))));
            }
            return openOsm;
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    private static class AllowDownload
    extends AbstractAction {
        private final CanVecTile tile;

        private AllowDownload(CanVecTile tile) {
            super(tile.tileid);
            this.tile = tile;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.tile.canDownload = true;
        }
    }

    private static class MaxZoomAction
    extends AbstractAction
    implements Layer.LayerAction {
        private final CanvecLayer parent;

        private MaxZoomAction(CanvecLayer parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public boolean supportLayers(List<Layer> layers) {
            return false;
        }

        public Component createMenuComponent() {
            JMenu maxZoomMenu = new JMenu("max zoom");
            maxZoomMenu.add(new JMenuItem(new SetMaxZoom(this.parent, 1)));
            maxZoomMenu.add(new JMenuItem(new SetMaxZoom(this.parent, 2)));
            maxZoomMenu.add(new JMenuItem(new SetMaxZoom(this.parent, 3)));
            maxZoomMenu.add(new JMenuItem(new SetMaxZoom(this.parent, 4)));
            return maxZoomMenu;
        }
    }
}

