/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.property;

import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;

public abstract class RoadValueLimit
implements RoadPropertyType<Float> {
    private final String keyName;
    private final VehiclePropertyType<Float> vehicleProperty;
    private final LimitType upperLimit;

    protected RoadValueLimit(String keyName, VehiclePropertyType<Float> vehicleProperty, LimitType upperLimit) {
        assert (keyName != null && vehicleProperty != null && upperLimit != null);
        this.keyName = keyName;
        this.vehicleProperty = vehicleProperty;
        this.upperLimit = upperLimit;
    }

    protected abstract Float parse(String var1);

    @Override
    public <N, W, R, M> Float evaluateW(W way, boolean forward, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        assert (way != null && accessParameters != null && dataSource != null);
        return this.evaluateTags(dataSource.getTagsW(way));
    }

    @Override
    public <N, W, R, M> Float evaluateN(N node, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        assert (node != null && accessParameters != null && dataSource != null);
        return this.evaluateTags(dataSource.getTagsN(node));
    }

    private final Float evaluateTags(TagGroup tags) {
        String valueString = tags.getValue(this.keyName);
        if (valueString != null) {
            Float value = this.parse(valueString);
            return value;
        }
        return null;
    }

    @Override
    public boolean isUsable(Object propertyValue, AccessParameters accessParameters) {
        assert (propertyValue instanceof Float);
        Float vehicleValue = accessParameters.getVehiclePropertyValue(this.vehicleProperty);
        if (vehicleValue != null) {
            switch (this.upperLimit) {
                case MINIMUM: {
                    return vehicleValue.floatValue() >= ((Float)propertyValue).floatValue();
                }
                case MAXIMUM: {
                    return vehicleValue.floatValue() <= ((Float)propertyValue).floatValue();
                }
            }
            throw new Error("Unhandled LimitType");
        }
        return true;
    }

    protected static enum LimitType {
        MINIMUM,
        MAXIMUM;

    }
}

