/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class MercatorProjection
extends CylindricalProjection {
    public MercatorProjection() {
        this.minLatitude = ProjectionMath.degToRad(-85.0);
        this.maxLatitude = ProjectionMath.degToRad(85.0);
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate out) {
        if (this.spherical) {
            out.x = this.scaleFactor * lam;
            out.y = this.scaleFactor * Math.log(Math.tan(0.7853981633974483 + 0.5 * phi));
        } else {
            out.x = this.scaleFactor * lam;
            out.y = -this.scaleFactor * Math.log(ProjectionMath.tsfn(phi, Math.sin(phi), this.e));
        }
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate out) {
        if (this.spherical) {
            out.y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y / this.scaleFactor));
            out.x = x / this.scaleFactor;
        } else {
            out.y = ProjectionMath.phi2(Math.exp(-y / this.scaleFactor), this.e);
            out.x = x / this.scaleFactor;
        }
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isRectilinear() {
        return true;
    }

    @Override
    public int getEPSGCode() {
        return 9804;
    }

    @Override
    public String toString() {
        return "Mercator";
    }
}

