/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    private RowOutputBinary out;

    public RowInputBinary(byte[] byArray) {
        super(byArray);
    }

    public RowInputBinary(RowOutputBinary rowOutputBinary) {
        super(rowOutputBinary.getBuffer());
        this.out = rowOutputBinary;
    }

    @Override
    public int readType() throws IOException {
        return this.readShort();
    }

    @Override
    public String readString() throws IOException {
        int n = this.readInt();
        String string = StringConverter.readUTF(this.buffer, this.pos, n);
        string = ValuePool.getString(string);
        this.pos += n;
        return string;
    }

    @Override
    public boolean readNull() throws IOException {
        byte by = this.readByte();
        return by == 0;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() throws IOException {
        return ValuePool.getInt(this.readShort());
    }

    @Override
    protected Integer readInteger() throws IOException {
        return ValuePool.getInt(this.readInt());
    }

    @Override
    protected Long readBigint() throws IOException {
        return ValuePool.getLong(this.readLong());
    }

    @Override
    protected Double readReal() throws IOException {
        return ValuePool.getDouble(this.readLong());
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        byte[] byArray = this.readByteArray();
        int n = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return ValuePool.getBigDecimal(new BigDecimal(bigInteger, n));
    }

    @Override
    protected Boolean readBoole() throws IOException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        if (type.typeCode == 92) {
            return new TimeData(this.readInt(), this.readInt(), 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        long l = this.readLong();
        return new TimestampData(l);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        if (type.typeCode == 93) {
            return new TimestampData(this.readLong(), this.readInt());
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        long l = this.readLong();
        return new IntervalMonthData(l, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        long l = this.readLong();
        int n = this.readInt();
        return new IntervalSecondData(l, n, (IntervalType)type);
    }

    @Override
    protected Object readOther() throws IOException {
        return new JavaObjectData(this.readByteArray());
    }

    @Override
    protected BinaryData readBit() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[(n + 7) / 8];
        this.readFully(byArray);
        return BinaryData.getBitData(byArray, n);
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        return new BinaryData(this.readByteArray(), false);
    }

    @Override
    protected ClobData readClob() throws IOException {
        long l = super.readLong();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        long l = super.readLong();
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        int n = this.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readData(type);
        }
        return objectArray;
    }

    public int[] readIntArray() throws IOException {
        int n = this.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.readNull()) continue;
            nArray[i] = this.readInt();
        }
        return nArray;
    }

    @Override
    public Object[] readData(Type[] typeArray) throws IOException {
        return super.readData(typeArray);
    }

    public byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public char[] readCharArray() throws IOException {
        char[] cArray = new char[this.readInt()];
        if (this.count - this.pos < cArray.length) {
            this.pos = this.count;
            throw new EOFException();
        }
        for (int i = 0; i < cArray.length; ++i) {
            int n = this.buffer[this.pos++] & 0xFF;
            int n2 = this.buffer[this.pos++] & 0xFF;
            cArray[i] = (char)((n << 8) + n2);
        }
        return cArray;
    }

    public void resetRow(int n) {
        if (this.out != null) {
            this.out.reset(n);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    @Override
    public void resetRow(int n, int n2) throws IOException {
        if (this.out != null) {
            this.out.reset(n2);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(n, n2);
    }
}

