/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import com.sun.medialib.codec.g3fax.Encoder;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFRLECompressor;
import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFCodecLibRLECompressor
extends TIFFRLECompressor {
    private static final boolean DEBUG = false;
    Object encoder;

    public TIFFCodecLibRLECompressor() {
        try {
            Encoder encoder = new Encoder();
            this.encoder = encoder;
        }
        catch (Throwable t) {
            throw new RuntimeException("CodecLib not available");
        }
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        if (bitsPerSample.length != 1 || bitsPerSample[0] != 1) {
            throw new IIOException("Bits per sample must be 1 for RLE compression!");
        }
        int bytesPerRow = (width + 7) / 8;
        byte[] image = null;
        if (off == 0 && bytesPerRow == scanlineStride) {
            image = b;
        } else {
            image = new byte[bytesPerRow * height];
            int dataOffset = off;
            int imageOffset = 0;
            for (int row = 0; row < height; ++row) {
                System.arraycopy(b, dataOffset, image, imageOffset, bytesPerRow);
                dataOffset += scanlineStride;
                imageOffset += bytesPerRow;
            }
        }
        int maxBits = 9 * ((width + 1) / 2) + 2;
        byte[] compData = new byte[(maxBits + 7) / 8 * height];
        Encoder clibEncoder = (Encoder)this.encoder;
        int encodingFlags = 45;
        if (this.inverseFill) {
            encodingFlags |= 0x80;
        }
        int result = -1;
        try {
            result = clibEncoder.encode(compData, image, width, height, 2, encodingFlags);
            this.stream.write(compData, 0, result);
        }
        catch (Throwable t) {
            result = -1;
        }
        if (result == -1) {
            result = super.encode(b, off, width, height, bitsPerSample, scanlineStride);
        }
        return result;
    }
}

