/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;
import org.openstreetmap.josm.plugins.turnlanes.gui.InteractiveElement;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.Path;
import org.openstreetmap.josm.plugins.turnlanes.gui.State;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;

class RoadGui {
    private static final boolean ROUND_CORNERS = false;
    private final GuiContainer container;
    private final double innerMargin;
    private final double outerMargin;
    private final float lineWidth;
    private final Stroke regularStroke;
    private final Stroke dashedStroke;
    private final JunctionGui a;
    private final JunctionGui b;
    private final double length;
    private final IncomingConnector incomingA;
    private final IncomingConnector incomingB;
    private final Road road;
    private final List<Segment> segments = new ArrayList<Segment>();
    final double connectorRadius;

    private static final List<Point2D> prepended(List<Point2D> bends, Point2D point) {
        ArrayList<Point2D> result = new ArrayList<Point2D>(bends.size() + 1);
        result.add(point);
        result.addAll(bends);
        return result;
    }

    public RoadGui(GuiContainer container, Road road) {
        this.container = container;
        this.road = road;
        this.a = container.getGui(road.getFromEnd().getJunction());
        this.b = container.getGui(road.getToEnd().getJunction());
        this.incomingA = new IncomingConnector(road.getFromEnd());
        this.incomingB = new IncomingConnector(road.getToEnd());
        ArrayList<Point2D> bends = new ArrayList<Point2D>();
        List<Node> nodes = road.getRoute().getNodes();
        for (int i = nodes.size() - 2; i > 0; --i) {
            bends.add(container.translateAndScale(GuiUtil.loc(nodes.get(i))));
        }
        new Segment(this.b, bends, this.a);
        double l = 0.0;
        for (Segment s : this.segments) {
            l += s.length;
        }
        this.length = l;
        this.innerMargin = !this.incomingA.getLanes().isEmpty() && !this.incomingB.getLanes().isEmpty() ? 1.0 * container.getLaneWidth() / 15.0 : 0.0;
        this.outerMargin = container.getLaneWidth() / 6.0;
        this.connectorRadius = 3.0 * container.getLaneWidth() / 8.0;
        this.lineWidth = (float)(container.getLaneWidth() / 30.0);
        this.regularStroke = new BasicStroke(2.0f * this.lineWidth);
        this.dashedStroke = new BasicStroke(this.lineWidth, 0, 1, 10.0f, new float[]{(float)(container.getLaneWidth() / 2.0), (float)(container.getLaneWidth() / 3.0)}, 0.0f);
    }

    public JunctionGui getA() {
        return this.a;
    }

    public JunctionGui getB() {
        return this.b;
    }

    public Line2D getLeftCurb(Road.End end) {
        return GuiUtil.line(this.getCorner(end, true), this.getAngle(end) + Math.PI);
    }

    public Line2D getRightCurb(Road.End end) {
        return GuiUtil.line(this.getCorner(end, false), this.getAngle(end) + Math.PI);
    }

    private Point2D getLeftCorner(Road.End end) {
        return this.getCorner(end, true);
    }

    private Point2D getRightCorner(Road.End end) {
        return this.getCorner(end, false);
    }

    private Point2D getCorner(Road.End end, boolean left) {
        JunctionGui j = end.isFromEnd() ? this.a : this.b;
        double w = left ? this.getWidth(end, true) : this.getWidth(end, false);
        double s = left ? 1 : -1;
        double a = this.getAngle(end) + Math.PI;
        double t = left ? j.getLeftTrim(end) : j.getRightTrim(end);
        double dx = s * Math.cos(1.5707963267948966 - a) * w + Math.cos(a) * t;
        double dy = s * Math.sin(1.5707963267948966 - a) * w - Math.sin(a) * t;
        return new Point2D.Double(j.x + dx, j.y + dy);
    }

    private double getWidth(Road.End end, boolean left) {
        if (!end.getRoad().equals(this.road)) {
            throw new IllegalArgumentException();
        }
        int lcForward = this.incomingA.getLanes().size();
        int lcBackward = this.incomingB.getLanes().size();
        double LW = this.getContainer().getLaneWidth();
        double M = this.innerMargin + this.outerMargin;
        if (end.isToEnd()) {
            return (double)(left ? lcBackward : lcForward) * LW + M;
        }
        return (double)(left ? lcForward : lcBackward) * LW + M;
    }

    List<InteractiveElement> paint(Graphics2D g2d) {
        ArrayList<InteractiveElement> result = new ArrayList<InteractiveElement>();
        result.addAll(this.paintLanes(g2d));
        if (this.getModel().isPrimary()) {
            result.add(new ViaConnector(this.getModel().getFromEnd()));
            result.add(new ViaConnector(this.getModel().getToEnd()));
        } else {
            result.addAll(this.laneAdders());
            result.addAll(this.extenders(this.getModel().getFromEnd()));
            result.addAll(this.extenders(this.getModel().getToEnd()));
        }
        g2d.setColor(Color.RED);
        for (Segment s : this.segments) {
            g2d.fill(new Ellipse2D.Double(s.from.getX() - 1.0, s.from.getY() - 1.0, 2.0, 2.0));
        }
        return result;
    }

    private List<LaneAdder> laneAdders() {
        ArrayList<LaneAdder> result = new ArrayList<LaneAdder>(4);
        if (!this.incomingA.getLanes().isEmpty()) {
            result.add(new LaneAdder(this.getModel().getToEnd(), Lane.Kind.EXTRA_LEFT));
            result.add(new LaneAdder(this.getModel().getToEnd(), Lane.Kind.EXTRA_RIGHT));
        }
        if (!this.incomingB.getLanes().isEmpty()) {
            result.add(new LaneAdder(this.getModel().getFromEnd(), Lane.Kind.EXTRA_LEFT));
            result.add(new LaneAdder(this.getModel().getFromEnd(), Lane.Kind.EXTRA_RIGHT));
        }
        return result;
    }

    private List<Extender> extenders(Road.End end) {
        if (!end.isExtendable()) {
            return Collections.emptyList();
        }
        ArrayList<Extender> result = new ArrayList<Extender>();
        Node n = end.getJunction().getNode();
        for (Way w : OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class)) {
            if (w.getNodesCount() <= 1 || end.getWay().equals((Object)w) || !w.isFirstLastNode(n) || !Utils.isRoad(w)) continue;
            Node nextNode = w.firstNode().equals((Object)n) ? w.getNode(1) : w.getNode(w.getNodesCount() - 2);
            Point2D nextNodeLoc = this.getContainer().translateAndScale(GuiUtil.loc(nextNode));
            result.add(new Extender(end, w, GuiUtil.angle(this.a.getPoint(), nextNodeLoc)));
        }
        return result;
    }

    public Road getModel() {
        return this.road;
    }

    public IncomingConnector getConnector(Road.End end) {
        return end.isFromEnd() ? this.incomingA : this.incomingB;
    }

    private List<InteractiveElement> paintLanes(Graphics2D g2d) {
        Path2D.Double middleArea;
        boolean backward;
        Path2D.Double middleLines = new Path2D.Double();
        g2d.setStroke(this.regularStroke);
        boolean forward = !this.incomingA.getLanes().isEmpty();
        boolean bl = backward = !this.incomingB.getLanes().isEmpty();
        if (forward && backward) {
            this.paintLanes(g2d, middleLines, true);
            this.paintLanes(g2d, middleLines, false);
            middleLines.closePath();
            middleArea = middleLines;
            g2d.setColor(new Color(160, 160, 160));
        } else if (forward || backward) {
            this.paintLanes(g2d, middleLines, forward);
            middleArea = new Path2D.Double();
            ((Path2D)middleArea).append(middleLines.getPathIterator(null), false);
            ((Path2D)middleArea).append(this.middlePath(backward).offset(this.outerMargin, -1.0, -1.0, this.outerMargin).getIterator(), true);
            middleArea.closePath();
            g2d.setColor(Color.GRAY);
        } else {
            throw new AssertionError();
        }
        g2d.fill(middleArea);
        g2d.setColor(Color.WHITE);
        g2d.draw(middleLines);
        ArrayList<InteractiveElement> result = new ArrayList<InteractiveElement>();
        this.moveIncoming(this.getModel().getFromEnd());
        this.moveIncoming(this.getModel().getToEnd());
        result.add(this.incomingA);
        result.add(this.incomingB);
        for (IncomingConnector c : Arrays.asList(this.incomingA, this.incomingB)) {
            int offset = 0;
            for (LaneGui l : c.getLanes()) {
                this.moveOutgoing(l, offset++);
                result.add(l.outgoing);
                if (!l.getModel().isExtra()) continue;
                result.add(l.lengthSlider);
            }
        }
        return result;
    }

    private void paintLanes(Graphics2D g2d, Path2D middleLines, boolean forward) {
        Shape clip = this.clip();
        g2d.clip(clip);
        Path middle = this.middlePath(forward);
        Path innerPath = middle.offset(this.innerMargin, -1.0, -1.0, this.innerMargin);
        ArrayList<Path> linePaths = new ArrayList<Path>();
        linePaths.add(innerPath);
        for (LaneGui l : forward ? this.incomingA.getLanes() : this.incomingB.getLanes()) {
            l.setClip(clip);
            innerPath = l.recalculate(innerPath, middleLines);
            linePaths.add(innerPath);
        }
        Path2D.Double area = new Path2D.Double();
        GuiUtil.area(area, middle, innerPath.offset(this.outerMargin, -1.0, -1.0, this.outerMargin));
        g2d.setColor(Color.GRAY);
        g2d.fill(area);
        g2d.setColor(Color.WHITE);
        Path2D.Double lines = new Path2D.Double();
        ((Path2D)lines).append(innerPath.getIterator(), false);
        g2d.draw(lines);
        g2d.setColor(Color.WHITE);
        g2d.setStroke(this.dashedStroke);
        for (Path p : linePaths) {
            lines.reset();
            ((Path2D)lines).append(p.getIterator(), false);
            g2d.draw(lines);
        }
        g2d.setStroke(this.regularStroke);
        g2d.setClip(null);
    }

    private Shape clip() {
        Area clip = new Area(new Rectangle2D.Double(-100000.0, -100000.0, 200000.0, 200000.0));
        clip.subtract(new Area(this.negativeClip(true)));
        clip.subtract(new Area(this.negativeClip(false)));
        return clip;
    }

    private Shape negativeClip(boolean forward) {
        Road.End end = forward ? this.getModel().getToEnd() : this.getModel().getFromEnd();
        JunctionGui j = forward ? this.b : this.a;
        Line2D lc = this.getLeftCurb(end);
        Line2D rc = this.getRightCurb(end);
        Path2D.Double negativeClip = new Path2D.Double();
        double d = rc.getP1().distance(j.getPoint()) + lc.getP1().distance(j.getPoint());
        double cm = 0.01 / this.getContainer().getMpp();
        double rca = GuiUtil.angle(rc) + Math.PI;
        double lca = GuiUtil.angle(lc) + Math.PI;
        Point2D r1 = GuiUtil.relativePoint(GuiUtil.relativePoint(rc.getP1(), 1.0, GuiUtil.angle(lc.getP1(), rc.getP1())), cm, rca);
        Point2D r2 = GuiUtil.relativePoint(r1, d, rca);
        Point2D l1 = GuiUtil.relativePoint(GuiUtil.relativePoint(lc.getP1(), 1.0, GuiUtil.angle(rc.getP1(), lc.getP1())), cm, lca);
        Point2D l2 = GuiUtil.relativePoint(l1, d, lca);
        ((Path2D)negativeClip).moveTo(r1.getX(), r1.getY());
        ((Path2D)negativeClip).lineTo(r2.getX(), r2.getY());
        ((Path2D)negativeClip).lineTo(l2.getX(), l2.getY());
        ((Path2D)negativeClip).lineTo(l1.getX(), l1.getY());
        negativeClip.closePath();
        return negativeClip;
    }

    public Path getLaneMiddle(boolean forward) {
        Path mid = this.middlePath(!forward);
        double w = this.getWidth(forward ? this.getModel().getFromEnd() : this.getModel().getToEnd(), true);
        double o = (w - this.outerMargin) / 2.0;
        return o > 0.0 ? mid.offset(-o, -1.0, -1.0, -o) : mid;
    }

    private Path middlePath(boolean forward) {
        Path path = forward ? Path.create(this.b.x, this.b.y) : Path.create(this.a.x, this.a.y);
        Segment first = forward ? this.segments.get(this.segments.size() - 1) : this.segments.get(0);
        return first.append(path, forward, 0.0);
    }

    private void moveIncoming(Road.End end) {
        Point2D lc = this.getLeftCorner(end);
        Point2D rc = this.getRightCorner(end);
        Line2D.Double cornerLine = new Line2D.Double(lc, rc);
        double a = this.getAngle(end);
        Line2D roadLine = GuiUtil.line(this.getContainer().getGui(end.getJunction()).getPoint(), a);
        Point2D i = GuiUtil.intersection(roadLine, cornerLine);
        double offset = this.innerMargin + (this.getWidth(end, true) - this.innerMargin - this.outerMargin) / 2.0;
        Point2D loc = GuiUtil.relativePoint(i, offset, GuiUtil.angle(i, lc));
        this.getConnector(end).move(loc.getX(), loc.getY());
    }

    private void moveOutgoing(LaneGui lane, int offset) {
        Road.End end = lane.getModel().getOutgoingRoadEnd();
        Point2D lc = this.getLeftCorner(end);
        Point2D rc = this.getRightCorner(end);
        Line2D.Double cornerLine = new Line2D.Double(lc, rc);
        double a = this.getAngle(end);
        Line2D roadLine = GuiUtil.line(this.getContainer().getGui(end.getJunction()).getPoint(), a);
        Point2D i = GuiUtil.intersection(roadLine, cornerLine);
        double d = this.innerMargin + (double)(2 * offset + 1) * this.getContainer().getLaneWidth() / 2.0;
        Point2D loc = GuiUtil.relativePoint(i, d, GuiUtil.angle(i, rc));
        lane.outgoing.move(loc.getX(), loc.getY());
    }

    public JunctionGui getJunction(Road.End end) {
        if (!this.getModel().equals(end.getRoad())) {
            throw new IllegalArgumentException();
        }
        return end.isFromEnd() ? this.getA() : this.getB();
    }

    public double getAngle(Road.End end) {
        if (!this.getModel().equals(end.getRoad())) {
            throw new IllegalArgumentException();
        }
        if (end.isToEnd()) {
            return this.segments.get((int)(this.segments.size() - 1)).angle;
        }
        double angle = this.segments.get((int)0).angle;
        return angle > Math.PI ? angle - Math.PI : angle + Math.PI;
    }

    public double getWidth(Road.End end) {
        return this.getWidth(end, true) + this.getWidth(end, false);
    }

    public double getLength() {
        return this.length;
    }

    public double getOffset(double x, double y) {
        return this.segments.get(0).getOffset(x, y);
    }

    public GuiContainer getContainer() {
        return this.container;
    }

    public List<LaneGui> getLanes() {
        ArrayList<LaneGui> result = new ArrayList<LaneGui>();
        result.addAll(this.incomingB.getLanes());
        result.addAll(this.incomingA.getLanes());
        return Collections.unmodifiableList(result);
    }

    public List<LaneGui> getLanes(Road.End end) {
        return this.getConnector(end.getOppositeEnd()).getLanes();
    }

    private final class Segment {
        final Point2D to;
        final Point2D from;
        final Segment prev;
        final Segment next;
        final double length;
        final double angle;

        public Segment(Segment next, List<Point2D> bends, JunctionGui a) {
            Point2D head = (Point2D)bends.get(0).clone();
            List<Point2D> tail = bends.subList(1, bends.size());
            this.next = next;
            this.to = head;
            this.from = (Point2D)(tail.isEmpty() ? a.getPoint() : tail.get(0)).clone();
            this.prev = tail.isEmpty() ? null : new Segment(this, tail, a);
            this.length = this.from.distance(this.to);
            this.angle = GuiUtil.angle(this.from, this.to);
            RoadGui.this.segments.add(this);
        }

        public Segment(JunctionGui b, List<Point2D> bends, JunctionGui a) {
            this((Segment)null, (List<Point2D>)RoadGui.prepended(bends, (Point2D)b.getPoint().clone()), a);
        }

        private double getFromOffset() {
            return this.prev == null ? 0.0 : this.prev.getFromOffset() + this.prev.length;
        }

        public double getOffset(double x, double y) {
            return this.getOffsetInternal(new Point2D.Double(x, y), -1.0, Double.POSITIVE_INFINITY);
        }

        private double getOffsetInternal(Point2D p, double offset, double quality) {
            Point2D closest = GuiUtil.closest(new Line2D.Double(this.from, this.to), p);
            double myQuality = closest.distance(p);
            if (myQuality < quality) {
                quality = myQuality;
                Line2D normal = GuiUtil.line(p, this.angle + 1.5707963267948966);
                Point2D isect = GuiUtil.intersection(normal, new Line2D.Double(this.from, this.to));
                double d = this.from.distance(isect);
                boolean negative = Math.abs(GuiUtil.angle(this.from, isect) - this.angle) > 1.0;
                offset = this.getFromOffset() + (double)(negative ? -1 : 1) * d;
            }
            return this.next == null ? offset : this.next.getOffsetInternal(p, offset, quality);
        }

        public Path append(Path path, boolean forward, double offset) {
            if (forward) {
                Path tmp = path.lineTo(this.from.getX(), this.from.getY(), this.length);
                return this.prev == null ? tmp : this.prev.append(tmp, forward, 0.0);
            }
            Path tmp = path.lineTo(this.to.getX(), this.to.getY(), this.length);
            return this.next == null ? tmp : this.next.append(tmp, forward, 0.0);
        }
    }

    final class IncomingConnector
    extends InteractiveElement {
        private final Road.End end;
        private final List<LaneGui> lanes;
        private final Point2D center = new Point2D.Double();
        private final Ellipse2D circle = new Ellipse2D.Double();

        private IncomingConnector(Road.End end) {
            this.end = end;
            ArrayList<LaneGui> lanes = new ArrayList<LaneGui>(end.getLanes().size());
            for (Lane l : end.getOppositeEnd().getLanes()) {
                lanes.add(new LaneGui(RoadGui.this, l));
            }
            this.lanes = Collections.unmodifiableList(lanes);
        }

        @Override
        public void paintBackground(Graphics2D g2d, State state) {
            if (this.isActive(state)) {
                Composite old = g2d.getComposite();
                g2d.setComposite(((AlphaComposite)old).derive(0.2f));
                g2d.setColor(new Color(255, 127, 31));
                for (LaneGui l : this.lanes) {
                    l.fill(g2d);
                }
                g2d.setComposite(old);
            }
        }

        @Override
        public void paint(Graphics2D g2d, State state) {
            if (this.isVisible(state)) {
                Composite old = g2d.getComposite();
                if (this.isActive(state)) {
                    g2d.setComposite(((AlphaComposite)old).derive(1.0f));
                }
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.fill(this.circle);
                g2d.setComposite(old);
            }
        }

        private boolean isActive(State state) {
            if (!(state instanceof State.IncomingActive)) {
                return false;
            }
            Road.End roadEnd = ((State.IncomingActive)state).getRoadEnd();
            return roadEnd.equals(this.getRoadEnd());
        }

        private boolean isVisible(State state) {
            if (RoadGui.this.getModel().isPrimary() || !this.getRoadEnd().getJunction().isPrimary() || this.getRoadEnd().getOppositeEnd().getLanes().isEmpty()) {
                return false;
            }
            if (state instanceof State.Connecting) {
                return ((State.Connecting)state).getJunction().equals(this.getRoadEnd().getJunction());
            }
            return true;
        }

        @Override
        public boolean contains(Point2D p, State state) {
            if (!this.isVisible(state)) {
                return false;
            }
            if (this.circle.contains(p)) {
                return true;
            }
            for (LaneGui l : this.lanes) {
                if (!l.contains(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public InteractiveElement.Type getType() {
            return InteractiveElement.Type.INCOMING_CONNECTOR;
        }

        @Override
        public State activate(State old) {
            return new State.IncomingActive(this.getRoadEnd());
        }

        public Point2D getCenter() {
            return (Point2D)this.center.clone();
        }

        void move(double x, double y) {
            double r = RoadGui.this.connectorRadius;
            this.center.setLocation(x, y);
            this.circle.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        }

        public Road.End getRoadEnd() {
            return this.end;
        }

        public List<LaneGui> getLanes() {
            return this.lanes;
        }

        @Override
        int getZIndex() {
            return 1;
        }

        public void add(LaneGui lane) {
            this.lanes.add(lane);
        }
    }

    private final class LaneAdder
    extends InteractiveElement {
        private final Road.End end;
        private final Lane.Kind kind;
        private final Point2D center;
        private final Ellipse2D background;

        public LaneAdder(Road.End end, Lane.Kind kind) {
            double cy;
            double cx;
            this.end = end;
            this.kind = kind;
            double a = RoadGui.this.getAngle(end) + Math.PI;
            Point2D lc = RoadGui.this.getLeftCorner(end);
            Point2D rc = RoadGui.this.getRightCorner(end);
            double r = RoadGui.this.connectorRadius;
            if (kind == Lane.Kind.EXTRA_LEFT) {
                JunctionGui j = RoadGui.this.getContainer().getGui(end.getJunction());
                Point2D i = GuiUtil.intersection(GuiUtil.line(j.getPoint(), a), new Line2D.Double(lc, rc));
                cx = i.getX() + 1.3125 * r * (2.0 * Math.cos(a) + Math.cos(a - 1.5707963267948966));
                cy = i.getY() - 1.3125 * r * (2.0 * Math.sin(a) + Math.sin(a - 1.5707963267948966));
            } else {
                cx = rc.getX() + 1.3125 * r * (2.0 * Math.cos(a) + Math.cos(a + 1.5707963267948966));
                cy = rc.getY() - 1.3125 * r * (2.0 * Math.sin(a) + Math.sin(a + 1.5707963267948966));
            }
            this.center = new Point2D.Double(cx, cy);
            this.background = new Ellipse2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r);
        }

        @Override
        void paint(Graphics2D g2d, State state) {
            if (!this.isVisible(state)) {
                return;
            }
            g2d.setColor(Color.DARK_GRAY);
            g2d.fill(this.background);
            double l = 2.0 * RoadGui.this.connectorRadius / 3.0;
            Line2D.Double v = new Line2D.Double(this.center.getX(), this.center.getY() - l, this.center.getX(), this.center.getY() + l);
            Line2D.Double h = new Line2D.Double(this.center.getX() - l, this.center.getY(), this.center.getX() + l, this.center.getY());
            g2d.setStroke(new BasicStroke((float)(RoadGui.this.connectorRadius / 5.0)));
            g2d.setColor(Color.WHITE);
            g2d.draw(v);
            g2d.draw(h);
        }

        private boolean isVisible(State state) {
            return this.end.getJunction().isPrimary();
        }

        @Override
        boolean contains(Point2D p, State state) {
            return this.isVisible(state) && this.background.contains(p);
        }

        @Override
        InteractiveElement.Type getType() {
            return InteractiveElement.Type.LANE_ADDER;
        }

        @Override
        int getZIndex() {
            return 2;
        }

        @Override
        public State click(State old) {
            this.end.addLane(this.kind);
            return new State.Invalid(old);
        }
    }

    private final class Extender
    extends InteractiveElement {
        private final Road.End end;
        private final Way way;
        private final Line2D line;

        public Extender(Road.End end, Way way, double angle) {
            this.end = end;
            this.way = way;
            this.line = new Line2D.Double(RoadGui.this.a.getPoint(), GuiUtil.relativePoint(RoadGui.this.a.getPoint(), RoadGui.this.getContainer().getLaneWidth() * 4.0, angle));
        }

        @Override
        void paint(Graphics2D g2d, State state) {
            g2d.setStroke(RoadGui.this.getContainer().getConnectionStroke());
            g2d.setColor(Color.CYAN);
            g2d.draw(this.line);
        }

        @Override
        boolean contains(Point2D p, State state) {
            BasicStroke stroke = (BasicStroke)RoadGui.this.getContainer().getConnectionStroke();
            double strokeWidth = stroke.getLineWidth();
            Point2D closest = GuiUtil.closest(this.line, p);
            return p.distance(closest) <= strokeWidth / 2.0;
        }

        @Override
        State click(State old) {
            this.end.extend(this.way);
            return new State.Invalid(old);
        }

        @Override
        InteractiveElement.Type getType() {
            return InteractiveElement.Type.EXTENDER;
        }

        @Override
        int getZIndex() {
            return 0;
        }
    }

    final class ViaConnector
    extends InteractiveElement {
        private final Road.End end;
        private final Line2D line;
        private final float strokeWidth;

        public ViaConnector(Road.End end) {
            this.end = end;
            this.line = new Line2D.Double(RoadGui.this.getLeftCorner(end), RoadGui.this.getRightCorner(end));
            this.strokeWidth = (float)(3.0 * RoadGui.this.getContainer().getLaneWidth() / 4.0);
        }

        @Override
        void paint(Graphics2D g2d, State state) {
            if (this.isVisible(state)) {
                g2d.setStroke(new BasicStroke(this.strokeWidth, 1, 0));
                g2d.setColor(Color.ORANGE);
                g2d.draw(this.line);
            }
        }

        @Override
        boolean contains(Point2D p, State state) {
            if (!this.isVisible(state)) {
                return false;
            }
            Point2D closest = GuiUtil.closest(this.line, p);
            return p.distance(closest) <= (double)(this.strokeWidth / 2.0f);
        }

        private boolean isVisible(State state) {
            if (!(state instanceof State.Connecting)) {
                return false;
            }
            State.Connecting s = (State.Connecting)state;
            if (s.getJunction().equals(this.end.getJunction()) || this.equals(s.getBacktrackViaConnector())) {
                return true;
            }
            return !s.getViaConnectors().isEmpty() && s.getViaConnectors().get(s.getViaConnectors().size() - 1).getRoadModel().equals(this.getRoadModel());
        }

        private Road getRoadModel() {
            return RoadGui.this.getModel();
        }

        public RoadGui getRoad() {
            return RoadGui.this;
        }

        @Override
        InteractiveElement.Type getType() {
            return InteractiveElement.Type.VIA_CONNECTOR;
        }

        @Override
        int getZIndex() {
            return 1;
        }

        public Road.End getRoadEnd() {
            return this.end;
        }

        public Point2D getCenter() {
            return GuiUtil.relativePoint(this.line.getP1(), this.line.getP1().distance(this.line.getP2()) / 2.0, GuiUtil.angle(this.line.getP1(), this.line.getP2()));
        }
    }
}

