/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.GPSTagConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.plugins.photo_geotagging.SanselanFixes;
import org.openstreetmap.josm.tools.I18n;

public class ExifGPSTagger {
    public static void setExifGPSTag(File jpegImageFile, File dst, double lat, double lon, long gpsTime, Double ele) throws IOException {
        try {
            ExifGPSTagger.setExifGPSTagWorker(jpegImageFile, dst, lat, lon, gpsTime, ele);
        }
        catch (ImageReadException ire) {
            throw new IOException(I18n.tr((String)("Read error: " + ire), (Object[])new Object[0]), ire);
        }
        catch (ImageWriteException ire2) {
            throw new IOException(I18n.tr((String)("Write error: " + ire2), (Object[])new Object[0]), ire2);
        }
    }

    public static void setExifGPSTagWorker(File jpegImageFile, File dst, double lat, double lon, long gpsTime, Double ele) throws IOException, ImageReadException, ImageWriteException {
        TiffImageMetadata exif;
        TiffOutputSet outputSet = null;
        IImageMetadata metadata = Sanselan.getMetadata(jpegImageFile);
        JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
        if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
            outputSet = exif.getOutputSet();
        }
        if (null == outputSet) {
            outputSet = new TiffOutputSet();
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(gpsTime);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        DecimalFormat yearFormatter = new DecimalFormat("0000");
        DecimalFormat monthFormatter = new DecimalFormat("00");
        DecimalFormat dayFormatter = new DecimalFormat("00");
        String yearStr = yearFormatter.format(year);
        String monthStr = monthFormatter.format(month);
        String dayStr = dayFormatter.format(day);
        String dateStamp = yearStr + ":" + monthStr + ":" + dayStr;
        Number[] timeStamp = new Double[]{new Double(hour), new Double(minute), new Double(second)};
        TiffOutputField gpsTimeStamp = TiffOutputField.create(GPSTagConstants.GPS_TAG_GPS_TIME_STAMP, outputSet.byteOrder, timeStamp);
        TiffOutputDirectory exifDirectory = outputSet.getOrCreateGPSDirectory();
        exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_TIME_STAMP);
        exifDirectory.add(gpsTimeStamp);
        TiffOutputField gpsDateStamp = SanselanFixes.create(GPSTagConstants.GPS_TAG_GPS_DATE_STAMP, outputSet.byteOrder, dateStamp);
        exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_DATE_STAMP);
        exifDirectory.add(gpsDateStamp);
        SanselanFixes.setGPSInDegrees(outputSet, lon, lat);
        if (ele != null) {
            byte eleRef = ele >= 0.0 ? (byte)0 : 1;
            TiffOutputField gpsAltitudeRef = new TiffOutputField(GPSTagConstants.GPS_TAG_GPS_ALTITUDE_REF, FieldType.FIELD_TYPE_BYTE, 1, new byte[]{eleRef});
            exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_ALTITUDE_REF);
            exifDirectory.add(gpsAltitudeRef);
            Number[] val = new Number[]{Math.abs(ele)};
            byte[] bytes = FieldType.FIELD_TYPE_RATIONAL.writeData(val, outputSet.byteOrder);
            TiffOutputField gpsAltitude = new TiffOutputField(GPSTagConstants.GPS_TAG_GPS_ALTITUDE, FieldType.FIELD_TYPE_RATIONAL, 1, bytes);
            exifDirectory.removeField(GPSTagConstants.GPS_TAG_GPS_ALTITUDE);
            exifDirectory.add(gpsAltitude);
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));){
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, (OutputStream)os, outputSet);
        }
    }
}

