/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.OrderedHashSet;

public class View
extends TableDerived {
    SubQuery viewSubQuery;
    private String statement;
    private HsqlNameManager.HsqlName[] columnNames;
    SubQuery[] viewSubqueries;
    private OrderedHashSet schemaObjectNames;
    private int check;
    private Table baseTable;
    Expression checkExpression;
    boolean isTriggerInsertable;
    boolean isTriggerUpdatable;
    boolean isTriggerDeletable;

    View(Database database, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray, int n) {
        super(database, hsqlName, 8);
        this.columnNames = hsqlNameArray;
        this.check = n;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.schemaObjectNames;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
        OrderedHashSet orderedHashSet;
        ParserDQL parserDQL = new ParserDQL(session, new Scanner(this.statement));
        parserDQL.read();
        this.viewSubQuery = parserDQL.XreadViewSubquery(this);
        this.queryExpression = this.viewSubQuery.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = this.viewSubQuery.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != this.viewSubQuery.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.getName().statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        if ((orderedHashSet = this.queryExpression.getSubqueries()) == null) {
            this.viewSubqueries = new SubQuery[]{this.viewSubQuery};
        } else {
            orderedHashSet.add(this.viewSubQuery);
            this.viewSubqueries = new SubQuery[orderedHashSet.size()];
            orderedHashSet.toArray(this.viewSubqueries);
            ArraySort.sort(this.viewSubqueries, 0, this.viewSubqueries.length, this.viewSubqueries[0]);
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].parentView == null) {
                this.viewSubqueries[i].parentView = this;
            }
            this.viewSubqueries[i].prepareTable(session);
        }
        this.viewSubQuery.getTable().view = this;
        this.viewSubQuery.getTable().columnList = this.columnList;
        this.schemaObjectNames = parserDQL.compileContext.getSchemaObjectNames();
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            return;
        }
        switch (this.check) {
            case 0: {
                break;
            }
            case 1: {
                this.checkExpression = this.queryExpression.getCheckCondition();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ').append("VIEW");
        stringBuffer.append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        stringBuffer.append('(');
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getColumn((int)i).getName().statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')').append(' ').append("AS").append(' ');
        stringBuffer.append(this.getStatement());
        return stringBuffer.toString();
    }

    @Override
    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public boolean isTriggerInsertable() {
        return this.isTriggerInsertable;
    }

    @Override
    public boolean isTriggerUpdatable() {
        return this.isTriggerUpdatable;
    }

    @Override
    public boolean isTriggerDeletable() {
        return this.isTriggerDeletable;
    }

    @Override
    public boolean isInsertable() {
        return this.isTriggerInsertable ? false : super.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return this.isTriggerUpdatable ? false : super.isUpdatable();
    }

    @Override
    void addTrigger(TriggerDef triggerDef, HsqlNameManager.HsqlName hsqlName) {
        switch (triggerDef.operationType) {
            case 50: {
                if (this.isTriggerInsertable) {
                    throw Error.error(5538);
                }
                this.isTriggerInsertable = true;
                break;
            }
            case 19: {
                if (this.isTriggerDeletable) {
                    throw Error.error(5538);
                }
                this.isTriggerDeletable = true;
                break;
            }
            case 82: {
                if (this.isTriggerUpdatable) {
                    throw Error.error(5538);
                }
                this.isTriggerUpdatable = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.addTrigger(triggerDef, hsqlName);
    }

    @Override
    void removeTrigger(TriggerDef triggerDef) {
        switch (triggerDef.operationType) {
            case 50: {
                this.isTriggerInsertable = false;
                break;
            }
            case 19: {
                this.isTriggerDeletable = false;
                break;
            }
            case 82: {
                this.isTriggerUpdatable = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.removeTrigger(triggerDef);
    }

    public int getCheckOption() {
        return this.check;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String string) {
        this.statement = string;
    }

    @Override
    public void setDataReadOnly(boolean bl) {
        throw Error.error(4000);
    }

    public void collectAllFunctionExpressions(OrderedHashSet orderedHashSet) {
    }

    public Table getSubqueryTable() {
        return this.viewSubQuery.getTable();
    }

    public SubQuery[] getSubqueries() {
        return this.viewSubqueries;
    }
}

