/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.fid.IndexedFidReader;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.renderer.ScreenMap;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class ShapefileFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    SimpleFeatureType schema;
    ShapefileReader shp;
    DbaseFileReader dbf;
    int[] dbfindexes;
    SimpleFeatureBuilder builder;
    SimpleFeature nextFeature;
    Envelope targetBBox;
    double simplificationDistance;
    ScreenMap screenMap;
    StringBuffer idxBuffer;
    int idxBaseLen;
    IndexedFidReader fidReader;

    public ShapefileFeatureReader(SimpleFeatureType schema, ShapefileReader shp, DbaseFileReader dbf, IndexedFidReader fidReader) throws IOException {
        this.schema = schema;
        this.shp = shp;
        this.dbf = dbf;
        this.fidReader = fidReader;
        this.builder = new SimpleFeatureBuilder(schema);
        this.idxBuffer = new StringBuffer(schema.getTypeName());
        this.idxBuffer.append('.');
        this.idxBaseLen = this.idxBuffer.length();
        if (dbf != null) {
            List<AttributeDescriptor> atts = schema.getAttributeDescriptors();
            this.dbfindexes = new int[atts.size()];
            DbaseFileHeader head = dbf.getHeader();
            for (int i = 0; i < atts.size(); ++i) {
                AttributeDescriptor att = atts.get(i);
                if (att instanceof GeometryDescriptor) {
                    this.dbfindexes[i] = -1;
                    continue;
                }
                String attName = att.getLocalName();
                int count = 0;
                Map<Object, Object> userData = att.getUserData();
                if (userData.get("original") != null) {
                    attName = (String)userData.get("original");
                    count = (Integer)userData.get("count");
                }
                boolean found = false;
                for (int j = 0; j < head.getNumFields(); ++j) {
                    if (!head.getFieldName(j).equals(attName) || count-- > 0) continue;
                    this.dbfindexes[i] = j;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IOException("Could not find attribute " + attName + " (mul count: " + count);
            }
        }
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.hasNext()) {
            SimpleFeature result = this.nextFeature;
            this.nextFeature = null;
            return result;
        }
        throw new NoSuchElementException("hasNext() returned false");
    }

    boolean filesHaveMore() throws IOException {
        if (this.dbf == null) {
            return this.shp.hasNext();
        }
        boolean dbfHasNext = this.dbf.hasNext();
        boolean shpHasNext = this.shp.hasNext();
        if (dbfHasNext && shpHasNext) {
            return true;
        }
        if (dbfHasNext || shpHasNext) {
            throw new IOException((shpHasNext ? "Shp" : "Dbf") + " has extra record");
        }
        return false;
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this.nextFeature == null && this.filesHaveMore()) {
            Geometry geometry;
            boolean skip;
            ShapefileReader.Record record;
            block13: {
                record = this.shp.nextRecord();
                Envelope envelope = record.envelope();
                skip = false;
                geometry = null;
                if (this.schema.getGeometryDescriptor() != null) {
                    if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) {
                        skip = true;
                    } else if (this.simplificationDistance > 0.0 && envelope.getWidth() < this.simplificationDistance && envelope.getHeight() < this.simplificationDistance) {
                        try {
                            if (this.screenMap != null && this.screenMap.checkAndSet(envelope)) {
                                geometry = null;
                                skip = true;
                                break block13;
                            }
                            geometry = (Geometry)record.getSimplifiedShape(this.screenMap);
                        }
                        catch (Exception e) {
                            geometry = (Geometry)record.getSimplifiedShape();
                        }
                    } else {
                        geometry = (Geometry)record.shape();
                    }
                }
            }
            if (!skip) {
                DbaseFileReader.Row row;
                if (this.dbf != null) {
                    row = this.dbf.readRow();
                    if (row.isDeleted()) {
                        continue;
                    }
                } else {
                    row = null;
                }
                this.nextFeature = this.buildFeature(record.number, geometry, row);
                continue;
            }
            if (this.dbf == null) continue;
            this.dbf.skip();
        }
        return this.nextFeature != null;
    }

    SimpleFeature buildFeature(int number, Geometry geometry, DbaseFileReader.Row row) throws IOException {
        if (this.dbfindexes != null) {
            for (int i = 0; i < this.dbfindexes.length; ++i) {
                if (this.dbfindexes[i] == -1) {
                    this.builder.add(geometry);
                    continue;
                }
                this.builder.add(row.read(this.dbfindexes[i]));
            }
        } else if (geometry != null) {
            this.builder.add(geometry);
        }
        String featureId = this.buildFeatureId(number);
        return this.builder.buildFeature(featureId);
    }

    protected String buildFeatureId(int number) throws IOException {
        if (this.fidReader == null) {
            this.idxBuffer.delete(this.idxBaseLen, this.idxBuffer.length());
            this.idxBuffer.append(number);
            return this.idxBuffer.toString();
        }
        this.fidReader.goTo(number - 1);
        return this.fidReader.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.shp != null) {
                this.shp.close();
            }
        }
        finally {
            try {
                if (this.dbf != null) {
                    this.dbf.close();
                }
            }
            finally {
                try {
                    if (this.fidReader != null) {
                        this.fidReader.close();
                    }
                }
                finally {
                    this.shp = null;
                    this.dbf = null;
                }
            }
        }
    }

    public void setTargetBBox(Envelope targetBBox) {
        this.targetBBox = targetBBox;
    }

    public void setSimplificationDistance(double simplificationDistance) {
        this.simplificationDistance = simplificationDistance;
    }

    public void setScreenMap(ScreenMap screenMap) {
        this.screenMap = screenMap;
    }

    void disableShxUsage() throws IOException {
        this.shp.disableShxUsage();
    }

    ShapeType getShapeType() {
        return this.shp.getHeader().getShapeType();
    }
}

