/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class RawDataBlock
implements ListManagedBlock {
    private byte[] _data;
    private boolean _eof;
    private boolean _hasData;
    private static POILogger log = POILogFactory.getLogger(RawDataBlock.class);

    public RawDataBlock(InputStream inputStream, int n) throws IOException {
        this._data = new byte[n];
        int n2 = IOUtils.readFully(inputStream, this._data);
        boolean bl = this._hasData = n2 > 0;
        if (n2 == -1) {
            this._eof = true;
        } else if (n2 != n) {
            this._eof = true;
            String string = " byte" + (n2 == 1 ? "" : "s");
            log.log(POILogger.ERROR, "Unable to read entire block; " + n2 + string + " read before EOF; expected " + n + " bytes. Your document " + "was either written by software that " + "ignores the spec, or has been truncated!");
        } else {
            this._eof = false;
        }
    }

    public boolean eof() {
        return this._eof;
    }

    public boolean hasData() {
        return this._hasData;
    }

    public String toString() {
        return "RawDataBlock of size " + this._data.length;
    }

    @Override
    public byte[] getData() throws IOException {
        if (!this.hasData()) {
            throw new IOException("Cannot return empty data");
        }
        return this._data;
    }

    public int getBigBlockSize() {
        return this._data.length;
    }
}

