/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class FtCblsSubRecord
extends SubRecord {
    public static final short sid = 12;
    private static final int ENCODED_SIZE = 20;
    private byte[] reserved;

    public FtCblsSubRecord() {
        this.reserved = new byte[20];
    }

    public FtCblsSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 20) {
            throw new RecordFormatException("Unexpected size (" + n + ")");
        }
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        this.reserved = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FtCbls ]").append("\n");
        stringBuffer.append("  size     = ").append(this.getDataSize()).append("\n");
        stringBuffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append("\n");
        stringBuffer.append("[/FtCbls ]").append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(12);
        littleEndianOutput.writeShort(this.reserved.length);
        littleEndianOutput.write(this.reserved);
    }

    @Override
    protected int getDataSize() {
        return this.reserved.length;
    }

    public short getSid() {
        return 12;
    }

    @Override
    public Object clone() {
        FtCblsSubRecord ftCblsSubRecord = new FtCblsSubRecord();
        byte[] byArray = new byte[this.reserved.length];
        System.arraycopy(this.reserved, 0, byArray, 0, byArray.length);
        ftCblsSubRecord.reserved = byArray;
        return ftCblsSubRecord;
    }
}

