/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.intelligence;

import java.util.Collection;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;

public class SelectionMonitor
implements SelectionChangedListener {
    Collection<OsmPrimitive> lastSelection = new NotNullList<OsmPrimitive>();
    private static SelectionMonitor singleton = null;

    private SelectionMonitor() {
    }

    public static SelectionMonitor getInstance() {
        if (singleton == null) {
            singleton = new SelectionMonitor();
            DataSet.addSelectionListener((SelectionChangedListener)singleton);
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        Reasoner r;
        Reasoner reasoner = r = Reasoner.getInstance();
        synchronized (reasoner) {
            r.openTransaction();
            for (OsmPrimitive osmPrimitive : newSelection) {
                if (!House.isMatchable(osmPrimitive) && !Street.isMatchable(osmPrimitive)) continue;
                r.update(osmPrimitive);
            }
            for (OsmPrimitive osmPrimitive : this.lastSelection) {
                if (!House.isMatchable(osmPrimitive) && !Street.isMatchable(osmPrimitive)) continue;
                r.update(osmPrimitive);
            }
            r.closeTransaction();
        }
        this.lastSelection.clear();
        for (OsmPrimitive osmPrimitive : newSelection) {
            this.lastSelection.add(osmPrimitive);
        }
    }
}

