/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.text.PDTextState;
import org.apache.pdfbox.util.Matrix;

public class PDGraphicsState
implements Cloneable {
    private Matrix currentTransformationMatrix = new Matrix();
    private PDColorState strokingColor = new PDColorState();
    private PDColorState nonStrokingColor = new PDColorState();
    private PDTextState textState = new PDTextState();
    private double lineWidth = 0.0;
    private int lineCap = 0;
    private int lineJoin = 0;
    private double miterLimit = 0.0;
    private PDLineDashPattern lineDashPattern;
    private String renderingIntent;
    private boolean strokeAdjustment = false;
    private double alphaConstants = 0.0;
    private boolean alphaSource = false;
    private boolean overprint = false;
    private double overprintMode = 0.0;
    private double flatness = 1.0;
    private double smoothness = 0.0;
    private GeneralPath currentClippingPath;

    public PDGraphicsState() {
    }

    public PDGraphicsState(PDRectangle page) {
        this.currentClippingPath = new GeneralPath(new Rectangle(page.createDimension()));
        if (page.getLowerLeftX() != 0.0f || page.getLowerLeftY() != 0.0f) {
            this.currentTransformationMatrix = this.currentTransformationMatrix.multiply(Matrix.getTranslatingInstance(-page.getLowerLeftX(), -page.getLowerLeftY()));
        }
    }

    public Matrix getCurrentTransformationMatrix() {
        return this.currentTransformationMatrix;
    }

    public void setCurrentTransformationMatrix(Matrix value) {
        this.currentTransformationMatrix = value;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double value) {
        this.lineWidth = value;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int value) {
        this.lineCap = value;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(int value) {
        this.lineJoin = value;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(double value) {
        this.miterLimit = value;
    }

    public boolean isStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean value) {
        this.strokeAdjustment = value;
    }

    public double getAlphaConstants() {
        return this.alphaConstants;
    }

    public void setAlphaConstants(double value) {
        this.alphaConstants = value;
    }

    public boolean isAlphaSource() {
        return this.alphaSource;
    }

    public void setAlphaSource(boolean value) {
        this.alphaSource = value;
    }

    public boolean isOverprint() {
        return this.overprint;
    }

    public void setOverprint(boolean value) {
        this.overprint = value;
    }

    public double getOverprintMode() {
        return this.overprintMode;
    }

    public void setOverprintMode(double value) {
        this.overprintMode = value;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double value) {
        this.flatness = value;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double value) {
        this.smoothness = value;
    }

    public PDTextState getTextState() {
        return this.textState;
    }

    public void setTextState(PDTextState value) {
        this.textState = value;
    }

    public PDLineDashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public void setLineDashPattern(PDLineDashPattern value) {
        this.lineDashPattern = value;
    }

    public String getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(String value) {
        this.renderingIntent = value;
    }

    public Object clone() {
        PDGraphicsState clone = null;
        try {
            clone = (PDGraphicsState)super.clone();
            clone.setTextState((PDTextState)this.textState.clone());
            clone.setCurrentTransformationMatrix(this.currentTransformationMatrix.copy());
            clone.strokingColor = (PDColorState)this.strokingColor.clone();
            clone.nonStrokingColor = (PDColorState)this.nonStrokingColor.clone();
            if (this.lineDashPattern != null) {
                clone.setLineDashPattern((PDLineDashPattern)this.lineDashPattern.clone());
            }
            if (this.currentClippingPath != null) {
                clone.setCurrentClippingPath((GeneralPath)this.currentClippingPath.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public PDColorState getStrokingColor() {
        return this.strokingColor;
    }

    public PDColorState getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setCurrentClippingPath(Shape pCurrentClippingPath) {
        if (pCurrentClippingPath != null) {
            if (pCurrentClippingPath instanceof GeneralPath) {
                this.currentClippingPath = (GeneralPath)pCurrentClippingPath;
            } else {
                this.currentClippingPath = new GeneralPath();
                this.currentClippingPath.append(pCurrentClippingPath, false);
            }
        } else {
            this.currentClippingPath = null;
        }
    }

    public Shape getCurrentClippingPath() {
        return this.currentClippingPath;
    }
}

