/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CodespaceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private List<CodespaceRange> codeSpaceRanges = new ArrayList<CodespaceRange>();
    private Map<Integer, String> singleByteMappings = new HashMap<Integer, String>();
    private Map<Integer, String> doubleByteMappings = new HashMap<Integer, String>();
    private final Map<Integer, String> cidMappings = new HashMap<Integer, String>();
    private final List<CIDRange> cidRanges = new LinkedList<CIDRange>();

    public boolean hasOneByteMappings() {
        return this.singleByteMappings.size() > 0;
    }

    public boolean hasTwoByteMappings() {
        return this.doubleByteMappings.size() > 0;
    }

    public boolean hasCIDMappings() {
        return !this.cidMappings.isEmpty() || !this.cidRanges.isEmpty();
    }

    public String lookup(byte[] code, int offset, int length) {
        String result = null;
        if (length == 1) {
            int key = (code[offset] + 256) % 256;
            result = this.singleByteMappings.get(key);
        } else if (length == 2) {
            int intKey = (code[offset] + 256) % 256;
            intKey <<= 8;
            result = this.doubleByteMappings.get(intKey += (code[offset + 1] + 256) % 256);
        }
        return result;
    }

    public String lookupCID(int code) {
        if (this.cidMappings.containsKey(code)) {
            return this.cidMappings.get(code);
        }
        for (CIDRange range : this.cidRanges) {
            int ch = range.unmap(code);
            if (ch == -1) continue;
            return Character.toString((char)ch);
        }
        return null;
    }

    public void addMapping(byte[] src, String dest) throws IOException {
        if (src.length == 1) {
            this.singleByteMappings.put((src[0] + 256) % 256, dest);
        } else if (src.length == 2) {
            int intSrc = (src[0] + 256) % 256;
            intSrc <<= 8;
            this.doubleByteMappings.put(intSrc += (src[1] + 256) % 256, dest);
        } else {
            throw new IOException("Mapping code should be 1 or two bytes and not " + src.length);
        }
    }

    public void addCIDMapping(int src, String dest) throws IOException {
        this.cidMappings.put(src, dest);
    }

    public void addCIDRange(char from, char to, int cid) {
        this.cidRanges.add(0, new CIDRange(from, to, cid));
    }

    public void addCodespaceRange(CodespaceRange range) {
        this.codeSpaceRanges.add(range);
    }

    public List<CodespaceRange> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    public void useCmap(CMap cmap) {
        this.codeSpaceRanges.addAll(cmap.codeSpaceRanges);
        this.singleByteMappings.putAll(cmap.singleByteMappings);
        this.doubleByteMappings.putAll(cmap.doubleByteMappings);
    }

    public boolean isInCodeSpaceRanges(byte[] code) {
        return this.isInCodeSpaceRanges(code, 0, code.length);
    }

    public boolean isInCodeSpaceRanges(byte[] code, int offset, int length) {
        for (CodespaceRange range : this.codeSpaceRanges) {
            if (range == null || !range.isInRange(code, offset, length)) continue;
            return true;
        }
        return false;
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int newWMode) {
        this.wmode = newWMode;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String name) {
        this.cmapName = name;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String version) {
        this.cmapVersion = version;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int type) {
        this.cmapType = type;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String newRegistry) {
        this.registry = newRegistry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String newOrdering) {
        this.ordering = newOrdering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int newSupplement) {
        this.supplement = newSupplement;
    }
}

