/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;

public class TagValues {
    private String m_strTag = "";
    private String m_strPreferredValues = "";
    private int m_nPos = 0;
    private boolean m_bPreferred = false;
    private String[] m_astrTagValues = null;
    private String[] m_astrTagValuesPreferred = null;

    public TagValues() {
        this.clearAll();
    }

    public void readBuildingTags(ServerParam param) {
        if (param == null || param.getTag() == null || param.getTag().equals("")) {
            this.clearAll();
            return;
        }
        if (param.getTag().equals(this.m_strTag) && param.getPreferredValues().equals(this.m_strPreferredValues)) {
            return;
        }
        this.clearAll();
        this.m_strTag = param.getTag();
        this.m_strPreferredValues = param.getPreferredValues();
        ArrayList<String> tagValues = new ArrayList<String>();
        List values = Main.main.getCurrentDataSet().getAutoCompletionManager().getValues(this.m_strTag);
        for (AutoCompletionListItem i : values) {
            tagValues.add(i.getValue());
        }
        this.m_astrTagValues = tagValues.toArray(new String[tagValues.size()]);
        if (this.m_strPreferredValues.equals("")) {
            this.m_astrTagValuesPreferred = new String[0];
        } else {
            String[] prefered = this.m_strPreferredValues.split(";");
            tagValues = new ArrayList();
            for (String str : prefered) {
                String temp = str.trim();
                if (this.getPos(temp, this.m_astrTagValues) < 0) continue;
                tagValues.add(temp);
            }
            this.m_astrTagValuesPreferred = tagValues.toArray(new String[tagValues.size()]);
            this.m_bPreferred = true;
            this.m_nPos = 0;
        }
    }

    private void clearAll() {
        this.m_strTag = "";
        this.m_strPreferredValues = "";
        this.m_nPos = 0;
        this.m_bPreferred = false;
        this.m_astrTagValues = null;
        this.m_astrTagValuesPreferred = null;
    }

    public String getTag() {
        if (this.m_strTag == null || this.m_strTag.equals("")) {
            return null;
        }
        return this.m_strTag;
    }

    public String getTagValue() {
        if (!this.m_bPreferred) {
            if (this.m_astrTagValues != null && this.m_astrTagValues.length > this.m_nPos) {
                return this.m_astrTagValues[this.m_nPos];
            }
        } else if (this.m_astrTagValuesPreferred != null && this.m_astrTagValuesPreferred.length > this.m_nPos) {
            return this.m_astrTagValuesPreferred[this.m_nPos];
        }
        return null;
    }

    private int getPos(String value, String[] values) {
        if (value != null && values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (!value.equals(values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void left() {
        if (this.m_astrTagValues == null || this.m_astrTagValues.length == 0) {
            return;
        }
        if (!this.m_bPreferred) {
            if (this.m_astrTagValuesPreferred == null || this.m_astrTagValuesPreferred.length == 0) {
                return;
            }
            this.m_bPreferred = true;
            this.m_nPos = this.getPos(this.m_astrTagValues[this.m_nPos], this.m_astrTagValuesPreferred);
            if (this.m_nPos < 0) {
                this.m_nPos = 0;
                return;
            }
        }
        --this.m_nPos;
        if (this.m_nPos < 0) {
            this.m_nPos = this.m_astrTagValuesPreferred.length - 1;
        }
    }

    public void right() {
        if (this.m_astrTagValues == null || this.m_astrTagValues.length == 0) {
            return;
        }
        if (!this.m_bPreferred) {
            if (this.m_astrTagValuesPreferred == null || this.m_astrTagValuesPreferred.length == 0) {
                return;
            }
            this.m_bPreferred = true;
            this.m_nPos = this.getPos(this.m_astrTagValues[this.m_nPos], this.m_astrTagValuesPreferred);
            if (this.m_nPos < 0) {
                this.m_nPos = 0;
                return;
            }
        }
        ++this.m_nPos;
        if (this.m_nPos >= this.m_astrTagValuesPreferred.length) {
            this.m_nPos = 0;
        }
    }

    public void up() {
        if (this.m_astrTagValues == null || this.m_astrTagValues.length == 0) {
            return;
        }
        if (this.m_bPreferred) {
            this.m_bPreferred = false;
            this.m_nPos = this.getPos(this.m_astrTagValuesPreferred[this.m_nPos], this.m_astrTagValues);
            if (this.m_nPos < 0) {
                this.m_nPos = 0;
                return;
            }
        }
        --this.m_nPos;
        if (this.m_nPos < 0) {
            this.m_nPos = this.m_astrTagValues.length - 1;
        }
    }

    public void down() {
        if (this.m_astrTagValues == null || this.m_astrTagValues.length == 0) {
            return;
        }
        if (this.m_bPreferred) {
            this.m_bPreferred = false;
            this.m_nPos = this.getPos(this.m_astrTagValuesPreferred[this.m_nPos], this.m_astrTagValues);
            if (this.m_nPos < 0) {
                this.m_nPos = 0;
                return;
            }
        }
        ++this.m_nPos;
        if (this.m_nPos >= this.m_astrTagValues.length) {
            this.m_nPos = 0;
        }
    }
}

